require './core/base/spec_helper'
require './core/twitch/video_player/player_core'

feature 'Muted Video ' do
  let(:player_url) { PlayerCoreData.player_core_url }
  let(:vod_url) { "#{VideoPlayerData.player_domain_url}/videos/v/159280707" }
  let(:start_playback_time) { 180 }
  let(:playback_time) { 310 }

  scenario "is not interrupted in the muted part" do
    skip 'BUG : CVP-1475'
    visit player_url
    expect(page).to have_css(PlayerCore.video_container)
    expect(PlayerCore.stream_started?(vod_url)).to be_truthy
    PlayerCore.seek_to_position(start_playback_time)

    # Broken playback duration because of Selenium TimeOut Error for long durations
    (playback_time / 20).to_i.times { expect(PlayerCore.smooth_playhead?(20)).to be_truthy }
  end
end
