require './core/base/spec_helper'
require './core/twitch/video_player/player_core'

feature 'Play / Pause - Seek' do
  player_url = PlayerCoreData.player_core_url
  let(:vod_url) { "#{PlayerCoreData.player_core_domain_for_vod}/videos/#{TwitchUtils.vod_id(VideoPlayerData.player_vod)}.m3u8" }

  before(:each) do
    visit player_url
    expect(page).to have_css(PlayerCore.video_container)
    expect(PlayerCore.stream_started?(vod_url)).to be_truthy
  end

  scenario "Pause-Seek : Playhead should move to new position and should stay paused" do
    # Verify Stream gets paused on player.pause();
    expect(PlayerCore.pause?).to be_truthy
    expect(PlayerCore.seek_completed?(50)).to be_truthy
    # Verify Stream is paused after seek
    expect(PlayerCore.is_paused?).to be_truthy, "[INFO] Current PlayerState - #{PlayerCore.get_player_state}"
  end

  scenario "Pause-Seek-Play : Playhead should move to new position on seeking and start playing when played after seek" do
    # Verify Stream is paused before seek
    expect(PlayerCore.pause?).to be_truthy
    before_seek = PlayerCore.current_playhead
    PlayerCore.seek_to_position(50)
    expect(PlayerCore.play).to be_within(5).of(before_seek + 50)
    expect(PlayerCore.is_paused?).to be_falsy
    expect(PlayerCore.playhead_changes_with_time?(5)).to be_truthy
  end

  scenario "Play-Seek : Playhead should seek and start playing" do
    # Verify Stream is not paused before seek
    expect(PlayerCore.is_paused?).to be_falsy
    expect(PlayerCore.seek_completed?(50)).to be_truthy
    # Verify Stream is not paused after seek
    expect(PlayerCore.is_paused?).to be_falsy
  end

  scenario "Play-Seek-Pause : Playhead should seek to new position and should be paused when paused after seek" do
    # Verify Stream is not paused before seek
    expect(PlayerCore.is_paused?).to be_falsy
    expect(PlayerCore.seek_completed?(50)).to be_truthy
    # Verify Stream gets paused on player.pause();
    expect(PlayerCore.pause?).to be_truthy
    # Verify Stream playhead doesn't changes when paused
    expect(PlayerCore.playhead_changes_with_time?(5)).to be_falsy
  end
end
