require './core/base/spec_helper'
require './core/twitch/video_player/player_core'

feature 'Play VOD' do

  let(:player_url) { PlayerCoreData.player_core_url }
  let(:vod_url) { "#{PlayerCoreData.player_core_domain_for_vod}/videos/#{TwitchUtils.vod_id(VideoPlayerData.player_vod)}.m3u8" }

  scenario 'stream for few seconds and validate time' do
    visit player_url
    expect(PlayerCore).to have_video_container
    expect(PlayerCore.stream_started?(vod_url)).to be_truthy
    expect(PlayerCore.smooth_playhead?(15)).to be_truthy
  end
end
