require './core/base/spec_helper'
require './core/twitch/video_player/player_core'

feature 'Validating VOD player-core events:' do
  let(:player_url) { PlayerCoreData.player_core_url }
  let(:vod_url) { "#{PlayerCoreData.player_core_domain_for_vod}/videos/#{TwitchUtils.vod_id(VideoPlayerData.player_vod)}.m3u8" }

  before(:each) do
    visit player_url
    expect(PlayerCore.stream_started?(vod_url)).to be_truthy
  end

  scenario "'READY' event fired upon vod stream start" do
    expect(PlayerCore).to have_ready_event(vod_url)
  end

  scenario "'Metadata ID3' fired 1 times upon vod stream start." do
    expect(PlayerCore).to have_metadata_event(vod_url)
  end

  scenario "'player.getPosition' increases as video progresses over a count 20 and 2 seconds wait upon stream start." do
    expect(PlayerCore.stream_started?(vod_url)).to be_truthy
    expect(PlayerCore.smooth_playhead?(20)).to eq(true)
  end

  scenario "Volume level can be changed" do
    visit player_url
    # Checking if stream can be paused
    expect(page).to have_css(PlayerCore.video_container, wait: 5)
    expect(PlayerCore.stream_started?(vod_url)).to be_truthy
    random_volume = rand.round(1).to_f # Rounding off to 1 decimal place
    PlayerCore.set_volume random_volume
    expect(PlayerCore.get_volume).to eql(random_volume)
  end
end
