require './core/base/spec_helper'
require './core/twitch/video_player/player_core'

feature 'Validating VOD ' do
  let(:player_url) { PlayerCoreData.player_core_url }
  let (:vod_url) { "#{PlayerCoreData.player_core_domain_for_vod}/videos/#{TwitchUtils.vod_id(VideoPlayerData.player_vod)}.m3u8" }
  let(:vod_qualities) { {Source: 710, High: 720, Medium: 480, Low: 360, Mobile: 226} }
  let(:fps) { 30 }

  before(:each) do
    visit player_url
    # Checking if stream can be paused
    expect(page).to have_css(PlayerCore.video_container, wait: 5)
    expect(PlayerCore.stream_started?(vod_url)).to be_truthy
  end

  scenario "resolution with its height", :unsupported_browsers => [:internet_explorer] do
    PlayerCore.available_quality_options.each do |quality|
      # Verify only for given quality keys in :vod_qualities hash
      next unless vod_qualities.keys.include? quality.text.to_sym
      # Select Quality from High, Medium, Low and Mobile
      expect(PlayerCore.set_quality?(quality.text)).to be_truthy
      # vod_qualities Hash for mapping Quality name to height
      curr_quality = PlayerCore.current_quality
      expect(vod_qualities[curr_quality['name'].to_sym].to_i).to eql(curr_quality['height'].to_i)
    end
  end

  scenario 'encoder latency is equal to broadcaster latency' do
    expect(PlayerCore.get_encoder_latency.to_s[0..4]).to be_eql(PlayerCore.get_broadcaster_latency.to_s[0..4])
  end

  scenario 'fps remains around 30 when playing at normal rate at different qualities', :unsupported_browsers => [:edge, :internet_explorer] do
    # BUG CVP-1438  for IE and Edge
    skip 'FPS is not constant and is falling beyond the expected range'
    PlayerCore.available_quality_options.each do |quality|
      # Skipping for 'Audio Only'
      next if quality.text.downcase.include? 'audio'
      expect(PlayerCore.set_quality?(quality.text)).to be_truthy

      expect(PlayerCore.get_fps).to be_within(2).of(fps), "expected #{PlayerCore.get_fps} to be around #{fps} for quality-#{quality.text}"
    end
  end

  scenario 'fps varies correctly with the change in playback rate', :unsupported_browsers => [:edge] do
    # BUG CVP-1438  for IE and Edge
    skip('Failing due to CVP-1444')
    # Doubles when PLayback rate is Doubles
    PlayerCore.set_playback_rate(2)

    expect(PlayerCore.get_playback_rate).to be_eql(2)
    expect(PlayerCore.get_fps).to be_within(2).of(fps * 2)
    # Reduced to half when playback rate is 0.5
    PlayerCore.set_playback_rate(0.5)

    expect(PlayerCore.get_fps).to be_within(2).of(fps * 0.5)
  end
end
