require './core/base/spec_helper'
require './core/twitch/video_player/player_core'

# quality_change_spec.rb is currently setup to only accept the following:
# vod: 78264336
# IMPORTANT: qualities options will vary depending on the the video.
feature 'Quality Changed' do
  let(:player_url) { PlayerCoreData.player_core_url }
  let(:vod_url) { "#{PlayerCoreData.player_core_domain_for_vod}/videos/#{TwitchUtils.vod_id(VideoPlayerData.player_vod)}.m3u8" }
  let(:quality_names) { PlayerCore.get_qualities_name }
  let(:source) { quality_names[0] }
  let(:medium) { quality_names[quality_names.size / 2] }
  let(:low) { quality_names[-2] }

  before(:each) do
    skip 'Bug ID: CVP-1439 skipped on IE' if page.driver.browser.browser == :internet_explorer
    visit player_url
    expect(PlayerCore.stream_started?(vod_url)).to be_truthy
  end

  scenario 'loading stream should load default Qualitiy Options' do
    qualities_key_strings = PlayerCore.get_quality_list.keys.join
    expect(PlayerCore.quality_dropdown.text).to eq(qualities_key_strings)
  end

  scenario 'Switch to Low quality' do
    PlayerCore.set_quality?(low)
    expect(PlayerCore.current_quality['name']).to eq(low)
  end

  scenario 'Switch to Source quality after switch to Low quality' do
    PlayerCore.set_quality?(low)
    expect(PlayerCore.current_quality['name']).to eq(low)
    # Set quality to source
    PlayerCore.set_quality?(source)
    expect(PlayerCore.current_quality['name']).to eq(source)
  end

  scenario 'Interrupt switch to Low quality with Switch to Medium quality', :unsupported_browsers => [:firefox] do
    expect(PlayerCore.set_quality?(low, 0)).to be_falsy
    # Set quality to medium
    PlayerCore.set_quality?(medium)
    expect(PlayerCore.current_quality['name']).to eq(medium)
  end
end
