require './core/base/spec_helper'
require './core/twitch/video_player/player_core'

feature 'Validating VoD Quality Changes' do
  player_url = PlayerCoreData.player_core_url
  let(:vod_url) { "#{PlayerCoreData.player_core_domain_for_vod}/videos/#{TwitchUtils.vod_id(VideoPlayerData.player_vod)}.m3u8" }
  let(:quality_names) { PlayerCore.get_qualities_name }

  before(:each) do
    visit player_url
    expect(page).to have_css(PlayerCore.video_container)
    expect(PlayerCore.stream_started?(vod_url)).to be_truthy
  end

  scenario "immediately when quality changed and seeked to non-buffered region " do
    skip('Fix in progress. See CVP-1965')
    expect(PlayerCore.set_quality_and_seek?(quality_names[-2], 20, 5)).to be_truthy
  end

  scenario "eventually seeked and changed quality" do
    skip 'Analyzing pending issue'
    expect(PlayerCore.seek_and_set_quality?(quality_names[-2], 20)).to be_truthy
  end
end
