require './core/base/spec_helper'
require './core/twitch/video_player/player_core'

feature 'Validating Vod' do
  player_url = PlayerCoreData.player_core_url
  let(:vod_url) { "#{PlayerCoreData.player_core_domain_for_vod}/videos/#{TwitchUtils.vod_id(VideoPlayerData.player_vod)}.m3u8" }

  before(:each) do
    visit player_url
    expect(page).to have_css(PlayerCore.video_container)
    expect(PlayerCore.stream_started?(vod_url)).to be_truthy
  end

  scenario "time increases when seeking forward" do
    expect(PlayerCore.seek_completed?(30)).to be_truthy
    expect(PlayerCore.playhead_changes_with_time?(3)).to be_truthy
  end

  scenario "time decreases when seeking backward" do
    # Seeking video forward for 50 seconds so that it can be seeked back
    expect(PlayerCore.seek_completed?(50)).to be_truthy

    # Seeking back scenario
    expect(PlayerCore.seek_completed?(-30)).to be_truthy
    expect(PlayerCore.seek_completed?(-5)).to be_truthy

    expect(PlayerCore.playhead_changes_with_time?(3)).to be_truthy
  end

  scenario "playback continues when seeked inside buffer region", :unsupported_browsers => [:firefox] do
    skip 'Skipping for now'
    buffered_duration = PlayerCore.get_buffer_duration
    seek_duration = buffered_duration/2
    expect(PlayerCore.seek_completed?(seek_duration)).to be_truthy
    expect(PlayerCore.playhead_changes_with_time?(5)).to be_truthy
  end

  scenario "playback continues when seeked outside buffer region" do
    buffered_duration = PlayerCore.get_buffer_duration
    seek_duration = buffered_duration + 10
    expect(PlayerCore.seek_completed?(seek_duration)).to be_truthy
    expect(PlayerCore.playhead_changes_with_time?(5)).to be_truthy
  end
end
