require './core/base/spec_helper'
require './core/twitch/video_player/player_core'

feature 'video_error spade event' do

  let(:tracked_event_name) { 'video_error' }
  let(:tracked_event) { PlayerCore.tracking_event(offline_stream, tracked_event_name) }
  let(:player_url) { PlayerCoreData.player_core_url }
  let(:offline_stream) { "#{VideoPlayerData.player_domain_url}/qa_auto_offline" }
  let(:error_message) { 'ErrorNotAvailable' }
  let(:video_name) { 'video_error' }
  let(:backend_value) { 'player-core' }
  let(:error_source_val) { 'Playlist' }
  let(:platform_value) { 'web' }
  let(:video_error_code) { 404 }
  let(:video_error_val) { 13 }
  let(:player_value) { 'web' }

  before(:each) do
    skip 'ToDo Fix CVP-2481/2532'
    visit player_url
    expect(PlayerCore.stream_started?).to be_truthy
    # Collecting Spade Event Data for validations
    expect(tracked_event).not_to be_falsy
  end

  scenario 'Video Error spade event has valid properties' do
    skip 'ToDo Fix CVP-2481'
    tracked_event_properties = tracked_event[0]['properties']
    expect(tracked_event_properties['time'].to_i).to be_within(3).of(tracked_event[1])
    expect(tracked_event_properties['muted']).to eql(PlayerCore.is_muted?)
    expect(tracked_event_properties['backend']).to eql(backend_value)
    expect(tracked_event_properties['video_error_source']).to eql(error_source_val)
    expect(tracked_event_properties['core_version']).to eql(PlayerCore.player_version)
    expect(tracked_event_properties['video_error_message']).not_to be_empty
    expect(tracked_event_properties['video_error_recoverable']).to be_falsy
    expect(tracked_event_properties['video_error_result']).to eql(error_message)
    expect(tracked_event_properties['platform']).to eql(platform_value)
    expect(tracked_event_properties['url']).to eql(offline_stream)
    expect(tracked_event_properties['volume']).to be_between(0, 1).inclusive
    expect(tracked_event_properties['video_error_code']).to eql(video_error_code)
    expect(tracked_event_properties['video_error_value']).to eql(video_error_val)
    expect(tracked_event_properties['live']).to be_truthy
    expect(tracked_event_properties['player']).to eql(player_value)
    expect(tracked_event_properties['platform']).to eql(platform_value)
  end

  scenario 'Video Error spade event has valid name' do
    skip 'ToDo Fix CVP-2532'
    tracked_event_name = tracked_event[0]['name']
    expect(tracked_event_name).to eql(video_name)
  end
end
