require './core/base/spec_helper'
require './core/twitch/video_player/player_ui'
require './core/twitch/video_player/player_page'

feature 'Test Channel \'food\'' do
  let(:food_channel) { "/?channel=food" }
  let(:quality_names) { PlayerCore.get_qualities_name }

  before(:each) do
    skip('Fix in progress')
    PlayerPage.visit_with_localstore_settings(food_channel)
  end

  scenario "has valid resolution with its height" do
    PlayerUI.available_quality_options.each do |quality|
      PlayerUI.set_quality_from_ui(quality)
      PlayerUI.open_settings_menu
      expect(page).to have_text(quality['name'])
      expect(quality['name'].to_i).to be_eql(quality['height']) unless quality['name'].eql? 'Auto'
    end
  end

  scenario 'can switch to Source quality after switch to Low quality' do
    quality_list = PlayerUI.available_quality_options
    PlayerUI.set_quality_from_ui(quality_list[-1])
    PlayerUI.open_settings_menu
    expect(page).to have_text(quality_list[-1]['name'])

    quality_list = PlayerUI.available_quality_options
    PlayerUI.set_quality_from_ui(quality_list[1])
    PlayerUI.open_settings_menu
    expect(page).to have_text(quality_list[1]['name'])
  end

  scenario 'Plays smoothly - Validate smooth playhead for 20 seconds' do
    expect(PlayerUI.smooth_playhead?(20)).to be_truthy
  end

  scenario 'Plays smoothly - Validate smooth fps for 30 seconds' do
    expect(PlayerUI.smooth_fps?(30, 30)).to be_truthy
  end
end
