require './core/base/spec_helper'
require './core/twitch/video_player/player_page'

# live_steam_spec.rb validates elements found on the player page against
# metadata from video_metadata_api.rb.
feature "Validating LIVE stream 'playing' event" do
  player_url = VideoPlayerData.player_stream_url
  player = PlayerPage.new('stream')

  scenario 'is triggered when defaultly landing on player' do
    skip('Flakey results. See VP-2239')
    PlayerPage.visit_with_localstore_settings(player_url)
    expect(PlayerPage.stream_playing_event?).to eq(true)
  end

  scenario "is triggered when '&autoplay=true'" do
    url = player_url + '&autoplay=true'
    PlayerPage.visit_with_localstore_settings(url)

    expect(PlayerPage.stream_playing_event?).to eq(true)
  end

  scenario "is not triggered when '&autoplay=false'" do
    url = player_url + '&autoplay=false'
    PlayerPage.visit_with_localstore_settings(url)

    expect(PlayerPage.stream_playing_event?).to eq(false)
  end

  scenario 'resumes after being paused for 5 seconds.' do
    PlayerPage.visit_with_localstore_settings(player_url)

    callback = PlayerPage.execute_async_script(video_paused_play_playing_event_script, 15)

    expect(callback).to eq(true)
  end

  scenario 'is not triggered when player is paused' do
    PlayerPage.visit_with_localstore_settings(player_url)
    expect(PlayerPage.stream_playing_event?).to eq(true)

    callback = PlayerPage.execute_async_script(video_paused_playing_event_script, 10)

    expect(callback).to eq(false)
  end
end

feature "Validating LIVE stream '&autoplay=false' parameter" do
  player_url = VideoPlayerData.player_stream_url
  player = PlayerPage.new('stream')

  scenario 'displays channel background preview image' do
    url = player_url + '&autoplay=false'
    PlayerPage.visit_with_localstore_settings(url)

    sleep(3) # Wait for stream metadata to resolve

    expect(PlayerPage.get_channel_background_preview).to include(StreamMetadataApi.channel_preview_url)
  end
end

feature "Validating LIVE stream 'pause' event" do
  # Setting player url to the base url.
  # Previously we would set it to player_stream_url, but when calling stream_playing_event? it would call setChannel(),
  # reinitializing and causing a pause event. See VP-3209 for more detail
  player_url = VideoPlayerData.player_base_url
  player = PlayerPage.new('stream')

  scenario 'is not triggered when defaultly landing on player' do
    skip('Flakey results. See VP-2239')
    url = player_url + '&debug'
    PlayerPage.visit_with_localstore_settings(url)

    # Set Channel & verify video has begun playing
    expect(PlayerPage.stream_playing_event?).to eq(true)

    puts "[DEBUG] player.getPaused(): #{Capybara.page.evaluate_script("player.getPaused()")}"
    expect(PlayerPage.video_pause_event?).to eq(false)
    puts "[DEBUG] player.getPaused(): #{Capybara.page.evaluate_script("player.getPaused()")}"
  end

  scenario "is not triggered when '&autoplay=true'" do
    url = player_url + '?autoplay=true'
    PlayerPage.visit_with_localstore_settings(url)

    # Set Channel & verify video has begun playing
    expect(PlayerPage.stream_playing_event?).to eq(true)

    puts "[DEBUG] player.getPaused(): #{Capybara.page.evaluate_script("player.getPaused()")}"
    expect(PlayerPage.video_pause_event?).to eq(false)
    puts "[DEBUG] player.getPaused(): #{Capybara.page.evaluate_script("player.getPaused()")}"
  end

  # See SMOC-268 for more details.
  scenario "is not triggered when '&autoplay=false'", :mediaplayer => true do
    skip('Flakey results. See VP-2239')
    url = player_url + '&autoplay=false'
    PlayerPage.visit_with_localstore_settings(url)

    puts "[DEBUG] player.getPaused(): #{Capybara.page.evaluate_script("player.getPaused()")}"
    expect(PlayerPage.video_pause_event?).to eq(false)
    puts "[DEBUG] player.getPaused(): #{Capybara.page.evaluate_script("player.getPaused()")}"
  end

  scenario 'is triggered when pressing Pause button' do
    skip('See SMOC-277')
    url = player_url + '&debug' # SMOC-233 - Using debug line to get 'paused event'
    PlayerPage.visit_with_localstore_settings(url)

    # First we verify that the video has begun playing before verifying
    expect(PlayerPage.stream_playing_event?).to eq(true)

    PlayerPage.click_play_pause_btn # Pause the stream
    puts "[DEBUG] player.getPaused(): #{Capybara.page.evaluate_script("player.getPaused()")}"

    expect(PlayerPage.video_pause_event?).to eq(true)
  end
end

feature 'Validating pausing LIVE stream' do
  player_url = VideoPlayerData.player_stream_url
  player = PlayerPage.new('stream')

  scenario "shows the play button overlay" do
    PlayerPage.visit_with_localstore_settings(player_url)

    # First we verify that the video has begun playing before verifying
    expect(PlayerPage.stream_playing_event?).to eq(true)

    PlayerPage.click_play_pause_btn # Pause the stream
    puts "[DEBUG] player.getPaused(): #{Capybara.page.evaluate_script("player.getPaused()")}"

    sleep(10) # Simulate pausing
    puts "[DEBUG] player.getPaused(): #{Capybara.page.evaluate_script("player.getPaused()")}"

    expect(PlayerPage.play_btn_overlay_css?).to eq(true)
  end
end

# In cases like these, we inject the script and refresh the channel.
# Warning: async scripts do not follow through an unload.
def video_paused_play_playing_event_script
  script =
    "var callback = arguments[arguments.length - 1];
    player.addEventListener('playing', function() { callback(true)});
    player.pause();
    setTimeout(function () { player.play(); }, 5000);"
  return script
end

def video_paused_playing_event_script
  script =
    "var callback = arguments[arguments.length - 1];
    player.addEventListener('playing', function() { callback(true)});
    player.pause();"
  return script
end
