require './core/base/spec_helper'
require './core/twitch/video_player/player_page'

# live_steam_spec.rb validates elements found on the player page against
# metadata from video_metadata_api.rb.
feature 'Autoplay LIVE Stream UI: Validating UI Presence of' do
  player_url = VideoPlayerData.player_stream_url
  player = PlayerPage.new('stream')

  before(:each) do
    PlayerPage.visit_with_localstore_settings(player_url)

    # First we verify that the video has begun playing before verifying
    expect(PlayerPage.stream_playing_event?).to eq(true)
    PlayerPage.hover_ui
  end

  scenario "Broadcast stream information" do
    expect(PlayerPage.get_broadcasters_logo).to eq(StreamMetadataApi.broadcaster_logo)
    expect(PlayerPage.get_broadcasters_display_name).to eq(StreamMetadataApi.broadcaster_display_name)
    expect(PlayerPage.get_broadcasters_game).to eq(StreamMetadataApi.broadcaster_game)
  end

  scenario "Player Buttons" do
    expect(PlayerPage.play_pause_btn_present?).to eq(true)
    expect(PlayerPage.volume_btn_present?).to eq(true)
    expect(PlayerPage.options_btn_present?).to eq(true)
    expect(PlayerPage.fullscreen_btn_present?).to eq(true)
    expect(PlayerPage.twitch_logo_btn_present?).to eq(true)
  end

  scenario "broadcaster's title" do
    skip("Need to see if whitespace matters.")
    expect(PlayerPage.get_broadcasters_title).to eq(StreamMetadataApi.broadcaster_title)
  end
end

feature "Validating LIVE stream '&autoplay=false' parameter" do
  player_url = VideoPlayerData.player_stream_url
  player = PlayerPage.new('stream')

  scenario 'displays play button overlay' do
    url = player_url + '&autoplay=false'
    PlayerPage.visit_with_localstore_settings(url)

    expect(PlayerPage.content_showing_event?).to eq(true)
    expect(PlayerPage.play_btn_overlay_css?).to eq(true)
  end

  scenario 'displays channel background preview image' do
    url = player_url + '&autoplay=false'
    PlayerPage.visit_with_localstore_settings(url)

    expect(PlayerPage.content_showing_event?).to eq(true)
    expect(PlayerPage.get_channel_background_preview).to include(StreamMetadataApi.channel_preview_url)
  end
end

feature 'Validating pausing LIVE stream' do
  player_url = VideoPlayerData.player_stream_url
  player = PlayerPage.new('stream')

  scenario 'displays play button overlay' do
    skip('Flakey results. See VP-2239')
    PlayerPage.visit_with_localstore_settings(player_url)

    # First we verify that the video has begun playing before verifying
    expect(PlayerPage.stream_playing_event?).to eq(true)

    PlayerPage.click_play_pause_btn # Pause the stream
    sleep(10) # Simulate pausing

    expect(PlayerPage.play_btn_overlay_css?).to eq(true)
  end
end

feature 'Validating LIVE stream player Play button overlay' do
  player_url = VideoPlayerData.player_stream_url
  player = PlayerPage.new('stream')

  scenario 'does not display when defaultly landing on player' do
    skip('Flakey results. See VP-2239')
    PlayerPage.visit_with_localstore_settings(player_url)

    # First we verify that the video has begun playing before verifying
    # Play button overlay is not defaultly present on landing.
    expect(PlayerPage.stream_playing_event?).to eq(true)

    expect(PlayerPage.no_play_btn_overlay_css?).to eq(true)
  end
end

# feature 'Validating LIVE stream fullscreen' do
#   # scenario 'can expand' do
#   #   skip('todo')
#   #   # player-button-fullscreen
#   # end
#   #
#   # scenario 'can collapse' do
#   #   skip('todo')
#   #   # player-button-fullscreen
#   # end
# end
#
# feature 'Validating LIVE stream Options menu' do
#   # scenario 'can open' do
#   #   skip('todo')
#   #   # player-button-settings
#   # end
#   #
#   # scenario 'can close' do
#   #   skip('todo')
#   #   # player-button-settings
#   # end
# end
#
# feature 'Validating LIVE stream Volume slider' do
#   # scenario 'can be set to max' do
#   #   skip('todo')
#   #   # player-volume
#   # end
#   #
#   # scenario 'can be muted' do
#   #   skip('todo')
#   #   # player-volume
#   # end
# end
