require './core/base/spec_helper'
require './core/twitch/video_player/player_page'

feature "Validating Vod 'playing' event" do
  player_url = VideoPlayerData.player_vod_url
  player = PlayerPage.new('vod')

  scenario 'is triggered when defaultly landing on player' do
    PlayerPage.visit_with_localstore_settings(player_url)

    puts "[DEBUG] player.getPaused(): #{Capybara.page.evaluate_script("player.getPaused()")}"
    expect(PlayerPage.vod_playing_event?).to eq(true)
    puts "[DEBUG] player.getPaused(): #{Capybara.page.evaluate_script("player.getPaused()")}"
  end

  scenario "is triggered when '&autoplay=true'" do
    url =  player_url + '&autoplay=true'
    PlayerPage.visit_with_localstore_settings(url)

    puts "[DEBUG] player.getPaused(): #{Capybara.page.evaluate_script("player.getPaused()")}"
    expect(PlayerPage.vod_playing_event?).to eq(true)
    puts "[DEBUG] player.getPaused(): #{Capybara.page.evaluate_script("player.getPaused()")}"
  end

  scenario "is not triggered when '&autoplay=false'" do
    url = player_url + '&autoplay=false'
    PlayerPage.visit_with_localstore_settings(url)

    puts "[DEBUG] player.getPaused(): #{Capybara.page.evaluate_script("player.getPaused()")}"
    expect(PlayerPage.vod_playing_event?).to eq(false)
    puts "[DEBUG] player.getPaused(): #{Capybara.page.evaluate_script("player.getPaused()")}"
  end
end
