require './core/base/spec_helper'
require './core/twitch/video_player/player_ui'
require './core/twitch/video_player/player_core'
require './core/twitch/video_player/player_page'

feature 'Quality for VOD:' do
  let(:vod_url) { VideoPlayerData.player_vod_url }

  before(:each) do
    skip('Fix in progress')
    PlayerPage.visit_with_localstore_settings(vod_url)
  end

  scenario 'should load default quality options' do
    available_quality_options = PlayerUI.available_quality_options
    expected_quality_options = ['Auto', '710p', '720p', '480p', '360p', '226p']
    available_quality_options.each_with_index do |quality, index|
      expect(quality['name']).to be_eql(expected_quality_options[index])
    end
  end

  scenario 'can switch to Low quality' do
    quality_names = PlayerCore.get_qualities_name
    PlayerUI.set_quality_from_ui(quality_names[-1])
    PlayerUI.open_settings_menu
    expect(page).to have_text(quality_names[-1])
  end

  scenario 'can switch to Source quality after switch to Low quality' do
    quality_names = PlayerCore.get_qualities_name
    PlayerUI.set_quality_from_ui(quality_names[-1])
    PlayerUI.open_settings_menu
    expect(page).to have_text(quality_names[-1])

    quality_names = PlayerCore.get_qualities_name
    PlayerUI.set_quality_from_ui(quality_names[1])
    PlayerUI.open_settings_menu
    expect(page).to have_text(quality_names[1])
  end

  scenario 'Interrupt switch to Low quality with Switch to Medium quality' do
    quality_names = PlayerCore.get_qualities_name
    PlayerUI.set_quality_from_ui(quality_names[-1])
    quality_list = PlayerUI.available_quality_options
    quality_names = PlayerCore.get_qualities_name
    PlayerUI.set_quality_from_ui(quality_names[1])
    PlayerUI.open_settings_menu
    expect(page).to have_text(quality_names[1])
  end
end
