require './core/base/spec_helper'
require './core/twitch/video_player/player_page'

# vod_spec.rb validate elements found on player page against
# metadata from video_metadata_api.rb
feature 'VOD UI: Validating UI Presence of' do
  player_url = VideoPlayerData.player_vod_url
  player = PlayerPage.new('vod')

  before(:each) do
    PlayerPage.visit_with_localstore_settings(player_url)

    # First we verify that the video has begun playing before verifying
    expect(PlayerPage.vod_playing_event?).to eq(true)
    PlayerPage.hover_ui
  end

  scenario "Broadcast stream information" do
    expect(PlayerPage.get_broadcasters_logo).to eq(ChannelMetadataApi.broadcaster_logo)
    expect(PlayerPage.get_broadcasters_display_name).to eq(VodMetadataApi.broadcaster_display_name)
    expect(PlayerPage.get_broadcasters_title).to eq(VodMetadataApi.broadcaster_title)
  end

  # # player-controls-bottom
  scenario "Player Buttons" do
    expect(PlayerPage.play_pause_btn_present?).to eq(true)
    expect(PlayerPage.volume_btn_present?).to eq(true)
    expect(PlayerPage.options_btn_present?).to eq(true)
    expect(PlayerPage.fullscreen_btn_present?).to eq(true)
    expect(PlayerPage.twitch_logo_btn_present?).to eq(true)
  end
end
