require './core/base/spec_helper'
require './core/twitch/web/passport/login_page'
require './core/base/page_helper'
require './core/twitch/web/components/top_nav'

RSpec.configure do |c|
  c.include LoginPage
end

feature 'User cannot login' do
  twitch_automation = register_user('twitch_automation')

  before(:all) do
    set_bypass_captcha_cookie
  end

  before(:each) do
    visit '/login'

    # We already set the cookie before(:all), but we need to check for the cookie's existence on each scenario.
    # Reason: This bug- SMOC-33
    # If the cookie doesn't exist, set and refresh
    if PageHelper.get_cookie(get_captcha_bypass_cookie_name).nil?
      set_bypass_captcha_cookie
      visit current_url # Refresh
    end
  end

  let(:authentication_path_regex) { /\/(authentications|sessions)\/new\?\S+/ }
  # After an unsuccessful login, the path will include client_id and such
  # Ex: /authentications/new?client_id=36926892495301a632f2ce7a216&embed=0&error_code=&nonce=3a43cef252f76cb...

  scenario 'with a blank password', :tier2 => true do
    login_reduced(twitch_automation.user.username, '')

    expect(page).to have_content('Please enter your username and password.')
  end
end
