module "base" {
  source = "../../../../base"
}

# Create the bucket used for storing tfstate
resource "aws_s3_bucket" "tf-state-bucket" {
  bucket = "${module.base.tf-state-bucket}"
  acl = "private"
  tags {
    Name  = "${module.base.tf-state-bucket}"
    Owner = "reichsta"
    Alerts = "qa-automation@twitch.tv"
  }
  versioning {
    enabled = true
  }

  # Lets not accidentally delete:
  # https://www.terraform.io/docs/configuration/resources.html#prevent_destroy
  lifecycle {
    prevent_destroy = true
  }
}
