# IMPORTANT NOTE!
# R53 is currently not configured for twitch-web-dev
# Terraform must be configured for twitch-aws in order to use the r53 zone

provider "aws" {
  region  = "us-west-2"
  profile = "twitch-aws"
}

variable name {}
variable private_ip {}
variable ttl {
  default = "300"
}

variable r53_zone {
  default = "ZRG00SM48517Z"
}

resource "aws_route53_record" "r53_record" {
  zone_id = "${var.r53_zone}"
  name = "${var.name}"
  type = "A"
  ttl = "${var.ttl}"
  records = ["${var.private_ip}"]
}
