# Configure the remote_state location
resource "terraform_remote_state" "twitch_qa_aws" {
  backend = "s3"
  config {
    bucket = "tf-state-bucket"
    key = "tfstate/qa/terraform/accounts/twitch-qa-aws/s3/tf_state_qa"
  }
}

# Create the bucket used for storing tfstate
resource "aws_s3_bucket" "tf-state-bucket" {
  bucket = "tf-state-bucket"
  acl = "private"
  tags {
    Name  = "tf-state-bucket"
    Owner = "dylanr"
    Alerts = "qa-automation@twitch.tv"
  }
  versioning {
    enabled = true
  }

  # Lets not accidentally delete:
  # https://www.terraform.io/docs/configuration/resources.html#prevent_destroy
  lifecycle {
    prevent_destroy = true
  }
}
