This script is a wrapper to the *arc diff* command that we run when performing pull-requests.  The script will create a new diff in Phabricator and a new pull request in GitHub.  It will also link the two for you.  If a Diff / Pull_Request already exists, then it just does what *arc diff* does.
 
# Installation
Create a symlink in */usr/local/bin directory* to this script so that you can run it anywhere:

```
ln -sf /usr/local/bin/twarc $script_path
```

Where *$script_path* is the path where you have this script on your filesystem.  
For example, if my script was located in *~/Code/twitch/tools/twarc/twarc.py*, then my command would look like:

```
ln -sf /usr/local/bin/twarc ~/Code/twitch/tools/twarc/twarc.py
```

Now you can run the script anywhere by calling *twarc*.

**Note: This script requires python 2.7** in order to run.  By default, Mac OS ships with *python 2.6*.
Assuming you have Homebrew installed, run: `brew install python` to [safely install python on your system](http://docs.python-guide.org/en/latest/starting/install/osx/).

In order to run, this script requires that [hub](https://hub.github.com/) be installed and configured properly.  Run with the `--setup` arg once to get everything setup:
 
 ```
 twarc --setup
 ```


# Usage
Similar to `arc diff`, to use this script simply execute it in the working directory of your git project.  The script has a single argument that defines what branch you want to merge into.  By default, this is *origin/master*, you can change it by passing in a different name.

```
cd ~/my/path/to/smoca
twarc                    # Running this, will create a pull-request into the master branch since no argument was provided
twarc origin/my_branch   # Running this will create a pull-request into 'my_branch'  
```

# Using Sublime Text with Arc
If you have Sublime Text installed, then you can use it to edit your messages that `arc diff` requires.  When you run `twarc --setup` this integration will be done for you if sublime is already executable from the command-line.
To check if this is so, simply run `which subl`.  If a path returns, then it's hooked up and you can simply run `twarc --setup` to hook it up with arc.

If a path didn't return, then you can create a symlink to your Sublime executable to allow it be ran from the command-line.  Simply run the following:

```
ln -sf /usr/local/bin/subl $path_to_sublime
```

Where *$path_to_sublime* is the path to where Sublime is installed on your filesystem.  So, for example, on my machine it looks like this:

```
ln -sf /usr/local/bin/subl /Applications/Sublime\ Text.app/Contents/SharedSupport/bin/subl
```

Once pathed, run `twarc --setup` to hook it up with arc.