#!/usr/bin/env python

# coding: utf-8

import os
from setuptools import setup, find_packages
from twerk.version import get_version


def get_data_files(path):
    files = []
    path = os.path.abspath(path)
    for dirname, dirnames, filenames in os.walk(path):
        for filename in filenames:
            if os.path.splitext(filename)[1].lower() not in ['.py', '.pyc']:
                full_path = os.path.join(dirname, filename)
                files.append(os.path.relpath(full_path, path))
    return files


setup(
    name='twerk',
    author='Billy Grissom',
    author_email='gribilly@justin.tv',
    url='https://git-aws.internal.justin.tv/qa/twerk',
    description='Command-line utility for performing various QA tasks',
    long_description=open('README.md').read(),
    entry_points={'console_scripts': ['twerk = twerk.twerk:main']},
    version=get_version(),
    packages=find_packages(),
    package_data={'twerk': get_data_files('twerk')},
    include_package_data=True,
    zip_safe=False
)
