/*
 * Decompiled with CFR 0.152.
 */
package com.cbg.selenium.capabilities;

import java.util.Map;
import java.util.logging.Logger;

public class DesktopCapabilities {
    private String artifactURL;
    private String binaryRelativePath;
    private Map<String, Object> desktopCapabilities;
    private final String capabilityIdentifier = "desktopApp";
    private static final Logger log = Logger.getLogger(DesktopCapabilities.class.getName());

    public DesktopCapabilities(Map<String, Object> cbgCapabilites) {
        if (!cbgCapabilites.containsKey("desktopApp")) {
            log.fine("Not creating DesktopCapabilities object as the capability identifier desktopApp was not provided.");
            return;
        }
        if (!(cbgCapabilites.get("desktopApp") instanceof Map)) {
            log.warning("Not creating DesktopCapabilities object as the capabilities were not an instance of a map");
            return;
        }
        this.desktopCapabilities = (Map)cbgCapabilites.get("desktopApp");
        this.artifactURL = (String)this.desktopCapabilities.get("artifactURL");
        this.binaryRelativePath = (String)this.desktopCapabilities.get("binaryRelativePath");
    }

    public String getartifactURL() {
        return this.artifactURL;
    }

    public String getBinaryRelativePath() {
        return this.binaryRelativePath;
    }

    public boolean empty() {
        return this.artifactURL == null && this.binaryRelativePath == null;
    }
}

