/*
 * Decompiled with CFR 0.152.
 */
package com.cbg.selenium.capability_matcher;

import java.util.Map;
import java.util.logging.Logger;
import org.openqa.grid.internal.utils.DefaultCapabilityMatcher;

public class CBGCapabilityMatcher
extends DefaultCapabilityMatcher {
    private static final Logger log = Logger.getLogger(CBGCapabilityMatcher.class.getName());
    private static String osPlatform = "osPlatform";
    private static String osVersion = "osVersion";

    public boolean matches(Map<String, Object> nodeCapability, Map<String, Object> requestedCapability) {
        boolean match = super.matches(nodeCapability, requestedCapability);
        if (requestedCapability.containsKey(osPlatform) && match) {
            match = this.matchesOSPlatform(nodeCapability, requestedCapability);
        }
        if (requestedCapability.containsKey(osVersion) && match) {
            match = this.matchesOSVersion(nodeCapability, requestedCapability);
        }
        return match;
    }

    private boolean matchesOSVersion(Map<String, Object> nodeCapability, Map<String, Object> requestedCapability) {
        return this.capToStrMatch(nodeCapability, requestedCapability, osVersion);
    }

    private boolean matchesOSPlatform(Map<String, Object> nodeCapability, Map<String, Object> requestedCapability) {
        return this.capToStrMatch(nodeCapability, requestedCapability, osPlatform);
    }

    private boolean capToStrMatch(Map<String, Object> nodeCapability, Map<String, Object> requestedCapability, String capToMatch) {
        Boolean match = false;
        log.fine("Preparing to check for a capability match for cap: " + capToMatch);
        if (!nodeCapability.containsKey(capToMatch) || !requestedCapability.containsKey(capToMatch)) {
            return false;
        }
        try {
            String reqCap = requestedCapability.get(capToMatch).toString();
            String nodeCap = nodeCapability.get(capToMatch).toString();
            match = reqCap.equalsIgnoreCase(nodeCap);
            log.fine("Requested Capability <" + reqCap + "> matches node capability <" + nodeCap + ">: " + Boolean.toString(match));
            return match;
        }
        catch (NullPointerException e) {
            log.warning("While processing capabilities, encountered " + e.getClass().toString() + e.getMessage());
            return false;
        }
    }
}

