/*
 * Decompiled with CFR 0.152.
 */
package com.cbg.selenium.logger;

import com.cbg.utils.PagerDutyUtils;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public class PagerDutyLogHandler
extends Handler {
    private static final Logger log = Logger.getLogger(PagerDutyLogHandler.class.getName());
    private boolean triggerPagerDutyEvents = true;

    public PagerDutyLogHandler() {
        this.configure();
    }

    private void configure() {
        String cname;
        LogManager manager = LogManager.getLogManager();
        String triggerEventsUserInput = manager.getProperty((cname = this.getClass().getName()) + ".triggerPagerDutyEvents");
        if (triggerEventsUserInput == null || triggerEventsUserInput == "") {
            this.triggerPagerDutyEvents = true;
            log.info(String.format("User did not specify 'triggerPagerDutyEvents'. Set triggerPagerDutyEvents to: %s", this.triggerPagerDutyEvents));
        } else {
            this.triggerPagerDutyEvents = triggerEventsUserInput.equals("true");
            log.info(String.format("Set triggerPagerDutyEvents to: %s", this.triggerPagerDutyEvents));
        }
    }

    @Override
    public void publish(final LogRecord record) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                PagerDutyLogHandler.this.sendToPagerDuty(record);
            }
        }).start();
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() throws SecurityException {
    }

    private void sendToPagerDuty(LogRecord record) {
        Level level = record.getLevel();
        if (level == Level.WARNING || level == Level.SEVERE) {
            if (!this.triggerPagerDutyEvents) {
                log.info("Not triggering PagerDuty Event as user specified not to. Message Contents was: " + record.getMessage());
                return;
            }
            PagerDutyUtils.trigger(level, record.getMessage());
        }
    }
}

