/*
 * Decompiled with CFR 0.152.
 */
package com.cbg.selenium.objects;

import com.cbg.selenium.capabilities.DesktopCapabilities;
import java.util.Map;
import java.util.logging.Logger;

public class CBGCapabilities {
    private DesktopCapabilities desktopCapabilities;
    private Map<String, Object> cbgCapabilities;
    private final String capabilityIdentifier = "cbg";
    private static final Logger log = Logger.getLogger(CBGCapabilities.class.getName());

    public CBGCapabilities(Map<String, Object> requestedCapability) {
        if (!requestedCapability.containsKey("cbg")) {
            log.fine("Not creating object as the capability identifier cbg was not provided.");
            return;
        }
        if (!(requestedCapability.get("cbg") instanceof Map)) {
            log.warning("Not creating object as the capabilities were not an instance of a map");
            return;
        }
        this.cbgCapabilities = (Map)requestedCapability.get("cbg");
        this.desktopCapabilities = new DesktopCapabilities(this.cbgCapabilities);
    }

    public DesktopCapabilities getDesktopCapabilities() {
        return this.desktopCapabilities;
    }

    public boolean empty() {
        return this.desktopCapabilities == null;
    }
}

