/*
 * Decompiled with CFR 0.152.
 */
package com.cbg.selenium.objects;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Logger;

public class ChromeOptCapabilities {
    private LinkedHashMap<String, Object> chromeOptions;
    private static final Logger log = Logger.getLogger(ChromeOptCapabilities.class.getName());
    private final String capabilityIdentifier = "chromeOptions";
    private final String binaryKey = "binary";

    public ChromeOptCapabilities(Map<String, Object> fullCapabilities) {
        this.chromeOptions = this.parseChromeCaps(fullCapabilities);
    }

    private LinkedHashMap<String, Object> parseChromeCaps(Map<String, Object> caps) {
        LinkedHashMap chromeOpts = new LinkedHashMap();
        if (!caps.containsKey("chromeOptions")) {
            return chromeOpts;
        }
        try {
            chromeOpts = (LinkedHashMap)caps.get("chromeOptions");
        }
        catch (ClassCastException e) {
            log.warning("Could not cast ChromeOptions. Exception: " + e.toString());
        }
        return chromeOpts;
    }

    public Map<String, Object> getChromeOptions() {
        return this.chromeOptions;
    }

    public Map<String, Object> getFullCapabilities(Map<String, Object> origCaps) {
        if (!this.chromeOptions.isEmpty()) {
            origCaps.put("chromeOptions", this.chromeOptions);
        }
        return origCaps;
    }

    public void setBinaryPath(String path) {
        this.chromeOptions.put("binary", path);
    }

    public String getBinaryPath() {
        if (this.chromeOptions.containsKey("binary")) {
            return (String)this.chromeOptions.get("binary");
        }
        return null;
    }
}

