/*
 * Decompiled with CFR 0.152.
 */
package com.cbg.selenium.objects;

import com.cbg.exceptions.UnauthorizedURLException;
import com.cbg.utils.DesktopFileUtils;
import com.cbg.utils.StatsUtils;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Logger;
import java.util.zip.ZipException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.ArrayUtils;

public class StandaloneApp {
    private static String rootFolder = "C:\\Program Files\\Twitch";
    private static final Logger log = Logger.getLogger(StandaloneApp.class.getName());
    private static final String statsdPrefix = "node.desktopApp";
    private String[] whitelistedDownloadHosts = new String[]{"desktop-builds.clients.internal.justin.tv"};
    private static final String unknownFolderIdentifier = "unknown";
    URL downloadURL;
    String artifactPath;
    File downloadFile;

    public static String getRootFolder() {
        if (rootFolder == null) {
            return null;
        }
        if (rootFolder.isEmpty()) {
            return null;
        }
        return rootFolder;
    }

    public static String getArtifactExtractionFolder(String downloadURL) {
        String folder = null;
        try {
            String filename = new File(new URL(downloadURL).getPath()).getName();
            folder = FilenameUtils.removeExtension(filename);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return folder;
    }

    public static String buildFullArtifactPath(String downloadURL) {
        String extractFolder = StandaloneApp.getArtifactExtractionFolder(downloadURL);
        if (StandaloneApp.getRootFolder() == null || StandaloneApp.getRootFolder().isEmpty() || extractFolder == null || extractFolder.isEmpty()) {
            log.warning("Could not identify root/extract folder, so returning unknown");
            return unknownFolderIdentifier;
        }
        return StandaloneApp.getRootFolder() + "\\" + extractFolder;
    }

    public StandaloneApp(String downloadURL) throws MalformedURLException {
        this.downloadURL = new URL(downloadURL);
        this.artifactPath = StandaloneApp.buildFullArtifactPath(downloadURL);
    }

    public void download() throws IOException, UnauthorizedURLException {
        if (!this.isAuthorizedDownloadURL().booleanValue()) {
            throw new UnauthorizedURLException();
        }
        if (StandaloneApp.getRootFolder() == null) {
            log.severe("Unable to download StandaloneApp. No root folder was provided.");
            throw new IOException();
        }
        long startTime = System.currentTimeMillis();
        this.downloadFile = DesktopFileUtils.downloadFromURL(this.downloadURL, StandaloneApp.getRootFolder());
        StatsUtils.getStatsdClient().recordExecutionTimeToNow("node.desktopApp.downloadTime", startTime);
    }

    public void install() throws ZipException, IOException {
        long startTime = System.currentTimeMillis();
        if (this.downloadFile == null || !this.downloadFile.exists()) {
            log.severe("Unable to install StandaloneApp. Problem with the downloaded file.");
            throw new IOException();
        }
        DesktopFileUtils.extractBinary(this.downloadFile, this.getArtifactPath());
        log.info(String.format("Deleting %s", this.downloadFile));
        FileUtils.deleteQuietly(this.downloadFile);
        this.downloadFile = null;
        StatsUtils.getStatsdClient().recordExecutionTimeToNow("node.desktopApp.installTime", startTime);
    }

    public void destroy() throws IOException {
        long startTime = System.currentTimeMillis();
        if (StandaloneApp.getRootFolder() == null) {
            log.warning("Unable to delete StandaloneApp as root folder is not provided.");
            return;
        }
        DesktopFileUtils.deleteDirectoryWithRetry(this.getArtifactPath());
        StatsUtils.getStatsdClient().recordExecutionTimeToNow("node.desktopApp.deleteTime", startTime);
    }

    public URL getDownloadURL() {
        return this.downloadURL;
    }

    public String getArtifactPath() {
        return this.artifactPath;
    }

    public Boolean exists() {
        if (this.getArtifactPath().equals(unknownFolderIdentifier)) {
            log.warning("Going to overwrite the unknown artifact folder");
            return false;
        }
        return new File(this.getArtifactPath()).exists();
    }

    public Boolean isAuthorizedDownloadURL() {
        return ArrayUtils.contains(this.whitelistedDownloadHosts, this.downloadURL.getHost());
    }
}

