/*
 * Decompiled with CFR 0.152.
 */
package com.cbg.selenium.proxy;

import com.cbg.selenium.objects.CBGCapabilities;
import com.cbg.selenium.objects.ChromeOptCapabilities;
import com.cbg.selenium.objects.StandaloneApp;
import com.cbg.selenium.servlets.DesktopApp;
import com.cbg.utils.ChromeOptUtils;
import com.cbg.utils.StatsUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.http.Consts;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.openqa.grid.common.RegistrationRequest;
import org.openqa.grid.internal.GridRegistry;
import org.openqa.grid.internal.TestSession;
import org.openqa.grid.selenium.proxy.DefaultRemoteProxy;

public class CBGRemoteProxy
extends DefaultRemoteProxy {
    private static final int CONNECTION_TIMEOUT = (int)TimeUnit.SECONDS.toMillis(120L);
    private static final Logger log = Logger.getLogger(CBGRemoteProxy.class.getName());
    private static final String statsdPrefix = "hub.proxy";

    public CBGRemoteProxy(RegistrationRequest arg0, GridRegistry arg1) {
        super(arg0, arg1);
        log.fine("CBG remote proxy has been loaded!");
    }

    public TestSession getNewSession(Map<String, Object> requestedCapability) {
        CBGCapabilities cbgCaps = new CBGCapabilities(requestedCapability);
        if (CBGRemoteProxy.requestIsADesktopAppTest(cbgCaps)) {
            requestedCapability = this.mergeNewChromeDriverCapabilities(requestedCapability, cbgCaps);
        }
        return super.getNewSession(requestedCapability);
    }

    public void beforeSession(TestSession session) {
        super.beforeSession(session);
        CBGCapabilities cbgCaps = new CBGCapabilities(session.getRequestedCapabilities());
        if (CBGRemoteProxy.requestIsADesktopAppTest(cbgCaps)) {
            this.requestApplicationInstallation(cbgCaps.getDesktopCapabilities().getartifactURL());
        }
    }

    public void afterSession(TestSession session) {
        CBGCapabilities cbgCaps = new CBGCapabilities(session.getRequestedCapabilities());
        if (CBGRemoteProxy.requestIsADesktopAppTest(cbgCaps)) {
            this.requestApplicationDeletion(true, false);
        }
        super.afterSession(session);
    }

    private void requestApplicationInstallation(String artifactURL) {
        StatsUtils.getStatsdClient().incrementCounter("hub.proxy.desktopApp.install");
        CloseableHttpClient client = this.getHTTPClient();
        String url = this.buildDesktopAppEndpoint();
        HttpPost post = new HttpPost(url);
        UrlEncodedFormEntity entity = this.createApplicationInstallPostData(artifactURL);
        post.setEntity(entity);
        this.process(client, post);
    }

    private void requestApplicationDeletion(Boolean killProcess, Boolean uninstall) {
        StatsUtils.getStatsdClient().incrementCounter("hub.proxy.desktopApp.uninstall");
        CloseableHttpClient client = this.getHTTPClient();
        String url = this.buildDesktopAppEndpoint();
        url = url + String.format("?kill=%b&uninstall=%b", killProcess, uninstall);
        HttpDelete deleteRequest = new HttpDelete(url);
        this.process(client, deleteRequest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void process(CloseableHttpClient client, HttpRequestBase request) {
        block15: {
            block14: {
                log.info(String.format("-> %s %s", request.getMethod(), request.getURI()));
                CloseableHttpResponse response = client.execute(request);
                log.info(String.format("<- [%s] | %s", response, request.getURI()));
                String metric = this.fmtRequestResponseForStatsd(request, response);
                StatsUtils.getStatsdClient().incrementCounter(metric);
                if (response.getStatusLine().getStatusCode() == 204) break block14;
                HttpEntity entity = response.getEntity();
                throw new RuntimeException(String.format("Unexpected response code %d. Path: %s | Message: %s", response.getStatusLine().getStatusCode(), request.getURI(), EntityUtils.toString(entity)));
            }
            try {
                client.close();
            }
            catch (Exception e) {
                log.warning(String.format("Problem closing request client. Received Back: %s", ExceptionUtils.getStackTrace(e)));
            }
            break block15;
            catch (ClientProtocolException e) {
                log.warning(String.format("Problem processing request %s %s. Received Back: %s", request.getMethod(), request.getURI().toString(), ExceptionUtils.getStackTrace(e)));
                try {
                    client.close();
                }
                catch (Exception e2) {
                    log.warning(String.format("Problem closing request client. Received Back: %s", ExceptionUtils.getStackTrace(e2)));
                }
            }
            catch (IOException e2) {
                log.warning(String.format("Problem processing request %s %s. Received Back: %s", request.getMethod(), request.getURI().toString(), ExceptionUtils.getStackTrace(e2)));
                {
                    catch (Throwable throwable) {
                        try {
                            client.close();
                        }
                        catch (Exception e3) {
                            log.warning(String.format("Problem closing request client. Received Back: %s", ExceptionUtils.getStackTrace(e3)));
                        }
                        throw throwable;
                    }
                }
                try {
                    client.close();
                }
                catch (Exception e4) {
                    log.warning(String.format("Problem closing request client. Received Back: %s", ExceptionUtils.getStackTrace(e4)));
                }
            }
        }
    }

    private UrlEncodedFormEntity createApplicationInstallPostData(String artifactURL) {
        ArrayList<BasicNameValuePair> formparams = new ArrayList<BasicNameValuePair>();
        formparams.add(new BasicNameValuePair("artifactURL", artifactURL));
        return new UrlEncodedFormEntity(formparams, Consts.UTF_8);
    }

    private String buildDesktopAppEndpoint() {
        return String.format("http://%s:%d/extra/%s", this.getRemoteHost().getHost(), this.getRemoteHost().getPort(), DesktopApp.class.getSimpleName());
    }

    private CloseableHttpClient getHTTPClient() {
        RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(CONNECTION_TIMEOUT).setSocketTimeout(CONNECTION_TIMEOUT).build();
        return HttpClientBuilder.create().setDefaultRequestConfig(requestConfig).build();
    }

    private Map<String, Object> mergeNewChromeDriverCapabilities(Map<String, Object> requestedCaps, CBGCapabilities cbgCaps) {
        ChromeOptCapabilities cOpts = new ChromeOptCapabilities(requestedCaps);
        ChromeOptUtils.mergeDesktopBinaryFromCapabilities(cbgCaps, cOpts, StandaloneApp.buildFullArtifactPath(cbgCaps.getDesktopCapabilities().getartifactURL()));
        log.info(String.format("Merged Desktop Capabilities into Chrome Options. New Chrome Options: %s", cOpts.getChromeOptions()));
        return cOpts.getFullCapabilities(requestedCaps);
    }

    private String fmtRequestResponseForStatsd(HttpRequestBase request, HttpResponse response) {
        return String.format("%s.requests.%s.%s.%s.%s", statsdPrefix, request.getMethod().toLowerCase(), StatsUtils.fmtIP(this.getRemoteHost().getHost()), request.getURI().getPath(), response.getStatusLine().getStatusCode());
    }

    public static boolean requestIsADesktopAppTest(CBGCapabilities cbgCaps) {
        try {
            return !cbgCaps.getDesktopCapabilities().empty() && cbgCaps.getDesktopCapabilities().getartifactURL() != null && !cbgCaps.getDesktopCapabilities().getartifactURL().isEmpty();
        }
        catch (NullPointerException e) {
            return false;
        }
    }
}

