/*
 * Decompiled with CFR 0.152.
 */
package com.cbg.selenium.servlets;

import com.cbg.exceptions.UnauthorizedURLException;
import com.cbg.selenium.objects.StandaloneApp;
import com.cbg.utils.DesktopFileUtils;
import com.cbg.utils.StatsUtils;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.logging.Logger;
import java.util.zip.ZipException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.SystemUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;

public class DesktopApp
extends HttpServlet {
    private static final long serialVersionUID = 8625877641262288475L;
    private static final Logger log = Logger.getLogger(DesktopApp.class.getName());
    private static final String statsdPrefix = "node.desktopApp";
    private StandaloneApp app;

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (!this.downloadURLIsPresent(request)) {
            response = this.returnErrorFromEnum(response, Error.MissingArtifactURL);
            return;
        }
        StatsUtils.getStatsdClient().incrementCounter("node.desktopApp.install");
        String downloadURL = this.getDownloadURL(request);
        try {
            this.app = new StandaloneApp(downloadURL);
        }
        catch (Exception e) {
            response = this.returnErrorFromEnum(response, Error.MalformedURL);
            log.info(String.format("When downloading from URL [%s], encountered exception: %s", downloadURL, ExceptionUtils.getStackTrace(e)));
            return;
        }
        if (!this.app.exists().booleanValue()) {
            try {
                this.app.download();
            }
            catch (IOException e) {
                response = this.returnErrorFromEnum(response, Error.IOException);
                log.warning(String.format("When downloading from URL [%s], encountered exception: %s", this.app.getDownloadURL(), ExceptionUtils.getStackTrace(e)));
                return;
            }
            catch (UnauthorizedURLException e) {
                response = this.returnErrorFromEnum(response, Error.UnauthorizedURL);
                log.info(String.format("Unauthorized URL [%s] was attempted to be downloaded", this.app.getDownloadURL()));
                return;
            }
            try {
                this.app.install();
            }
            catch (ZipException e) {
                response = this.returnErrorFromEnum(response, Error.ZipException);
                log.info(String.format("When extracting the file, encountered exception: %s", ExceptionUtils.getStackTrace(e)));
                try {
                    this.destroyApp();
                }
                catch (IOException eCleanup) {
                    log.warning(String.format("There was a problem cleaning up and deleting the app files. Exception: %s", ExceptionUtils.getStackTrace(eCleanup)));
                }
                return;
            }
            catch (IOException e) {
                response = this.returnErrorFromEnum(response, Error.IOException);
                log.warning(String.format("When extracting the file, encountered exception: %s", ExceptionUtils.getStackTrace(e)));
                try {
                    this.destroyApp();
                }
                catch (IOException eCleanup) {
                    log.warning(String.format("There was a problem cleaning up and deleting the app files. Exception: %s", ExceptionUtils.getStackTrace(eCleanup)));
                }
                return;
            }
        }
        log.info("Application already exists. Skipping Download/Install");
        log.info("Finished preparing the application. Returning.");
        response.setStatus(204);
    }

    public void doDelete(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String[] processNames = new String[]{"TwitchUI.exe", "TwitchAgent.exe"};
        String uninstall = request.getParameter("uninstall");
        String kill = request.getParameter("kill");
        log.fine(String.format("Params: Uninstall %s Kill %s", uninstall, kill));
        StatsUtils.getStatsdClient().incrementCounter("node.desktopApp.uninstall");
        if (kill != null && kill.equals("true")) {
            log.info("Killing Desktop processes");
            for (int i = 0; i < processNames.length; ++i) {
                String command;
                if (SystemUtils.IS_OS_WINDOWS) {
                    command = String.format("taskkill /F /IM %s", processNames[i]);
                } else if (SystemUtils.IS_OS_MAC || SystemUtils.IS_OS_LINUX) {
                    command = String.format("pkill \"%s\"", processNames[i]);
                } else {
                    log.severe("Could not determine OS for killing process. OS Name: " + SystemUtils.OS_NAME);
                    this.returnErrorFromEnum(response, Error.CannotKillProcessUnknownOS);
                    return;
                }
                log.fine("Executing " + command);
                Runtime.getRuntime().exec(command);
            }
            try {
                Thread.sleep(300L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (uninstall == null || uninstall.equals("true")) {
            log.info("Uninstalling Desktop Application");
            try {
                DesktopFileUtils.deleteDirectoryWithRetry(StandaloneApp.getRootFolder());
            }
            catch (IOException e) {
                log.warning(String.format("There was a problem cleaning up and deleting the app files. Exception: %s", ExceptionUtils.getStackTrace(e)));
                response = this.returnErrorFromEnum(response, Error.IOException);
                return;
            }
        }
        response.setStatus(204);
    }

    private void destroyApp() throws IOException {
        if (this.app != null) {
            this.app.destroy();
            this.app = null;
        }
    }

    private boolean downloadURLIsPresent(HttpServletRequest request) {
        String artifactURL = this.getDownloadURL(request);
        return artifactURL != null && !artifactURL.isEmpty();
    }

    private String getDownloadURL(HttpServletRequest request) {
        return request.getParameter("artifactURL");
    }

    private HttpServletResponse returnErrorFromEnum(HttpServletResponse response, Error err) throws IOException {
        return this.returnError(response, err.getStatusCode(), err.getDescription());
    }

    private HttpServletResponse returnError(HttpServletResponse response, int statusCode, String errorMsg) throws IOException {
        response.setStatus(statusCode);
        response.setContentType("application/json");
        PrintWriter out = response.getWriter();
        out.print(String.format("{\"error\":\"%s\"}", errorMsg));
        return response;
    }

    public static enum Error {
        MalformedURL(400, "The provided artifact url was not valid"),
        IOException(500, "There was a problem processing the artifact file. Please contact the server administrator"),
        CannotKillProcessUnknownOS(500, "There was a problem killing the desktop application process. Could not determine the OS"),
        ZipException(400, "There was a problem extracting the download contents. Ensure contents are of type ZIP"),
        UnauthorizedURL(422, "The artifactURL is not valid. Contact the server administrator."),
        MissingArtifactURL(422, "The required parameter artifactURL was not provided");

        private final int statusCode;
        private final String description;

        private Error(int statusCode, String description) {
            this.statusCode = statusCode;
            this.description = description;
        }

        public String getDescription() {
            return this.description;
        }

        public int getStatusCode() {
            return this.statusCode;
        }
    }
}

