/*
 * Decompiled with CFR 0.152.
 */
package com.cbg.utils;

import com.cbg.configs.CBGConfig;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import java.io.File;
import java.util.logging.Logger;

public class ConfigUtils {
    private static CBGConfig config;
    private static String configSystemProperty;
    private static final Logger log;

    public static CBGConfig getConfig() {
        if (config == null) {
            config = ConfigUtils.readConfig();
        }
        return config;
    }

    private static CBGConfig readConfig() {
        ObjectMapper mapper = new ObjectMapper(new YAMLFactory());
        CBGConfig configuration = new CBGConfig();
        File configFile = ConfigUtils.getConfigFile();
        if (configFile == null) {
            log.info("A configuration file was not provided. Skipping import");
            return configuration;
        }
        try {
            configuration = mapper.readValue(configFile, CBGConfig.class);
            log.info(String.format("Successfully loaded CBG Config from %s", configFile.toString()));
        }
        catch (Exception e) {
            log.warning("While reading config, encountered exception: " + e.getMessage());
        }
        return configuration;
    }

    private static File getConfigFile() {
        String configPath = System.getProperty(configSystemProperty);
        if (configPath == null || configPath.isEmpty()) {
            return null;
        }
        return new File(configPath);
    }

    static {
        configSystemProperty = "cbg.config.path";
        log = Logger.getLogger(ConfigUtils.class.getName());
    }
}

