/*
 * Decompiled with CFR 0.152.
 */
package com.cbg.utils;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;

public class DesktopFileUtils {
    private static final Logger log = Logger.getLogger(DesktopFileUtils.class.getName());

    public static File downloadFromURL(URL downloadURL, String destinationDirectory) throws MalformedURLException, IOException {
        String filename = FilenameUtils.getName(downloadURL.getPath());
        String destinationPath = String.format("%s\\%s", destinationDirectory, filename);
        File destination = new File(destinationPath);
        destination.getParentFile().mkdirs();
        log.info(String.format("Downloading URL %s to Destination %s", downloadURL, destination));
        FileUtils.copyURLToFile(downloadURL, destination);
        return destination;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void extractBinary(File sourceFile, String destinationPath) throws ZipException, IOException {
        ZipFile zipFile = new ZipFile(sourceFile);
        File extractDestination = new File(destinationPath);
        extractDestination.mkdirs();
        log.info(String.format("Unzipping the file %s to %s", sourceFile, extractDestination));
        try {
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                File entryDestination = new File(extractDestination, entry.getName());
                if (entry.isDirectory()) {
                    entryDestination.mkdirs();
                    continue;
                }
                entryDestination.getParentFile().mkdirs();
                InputStream in = zipFile.getInputStream(entry);
                FileOutputStream out = new FileOutputStream(entryDestination);
                IOUtils.copy(in, (OutputStream)out);
                in.close();
                ((OutputStream)out).close();
            }
        }
        finally {
            zipFile.close();
        }
        log.info(String.format("%s successfully unzipped to %s.", sourceFile, extractDestination));
    }

    public static void deleteDirectoryWithRetry(String directory) throws IOException {
        File appDir = new File(directory);
        log.info(String.format("Deleting Directory: %s", appDir));
        int attempts = 0;
        int maxAttempts = 10;
        while (attempts < maxAttempts) {
            try {
                ++attempts;
                FileUtils.deleteDirectory(appDir);
                log.info(String.format("Directory deleted: %s", appDir));
                break;
            }
            catch (IOException e) {
                log.fine(String.format("[%d/%d] Encountered exception when deleting %s. Exception: %s", attempts, maxAttempts, appDir, ExceptionUtils.getStackTrace(e)));
                if (attempts >= maxAttempts) {
                    throw e;
                }
                try {
                    TimeUnit.SECONDS.sleep(1L);
                }
                catch (InterruptedException e1) {
                    log.warning("While sleeping, encountered exception " + ExceptionUtils.getStackTrace(e1));
                }
            }
        }
    }
}

