/*
 * Decompiled with CFR 0.152.
 */
package com.cbg.utils;

import com.cbg.configs.CBGConfig;
import com.cbg.utils.ConfigUtils;
import com.github.dikhan.pagerduty.client.events.PagerDutyEventsClient;
import com.github.dikhan.pagerduty.client.events.domain.EventResult;
import com.github.dikhan.pagerduty.client.events.domain.Payload;
import com.github.dikhan.pagerduty.client.events.domain.Severity;
import com.github.dikhan.pagerduty.client.events.domain.TriggerIncident;
import com.github.dikhan.pagerduty.client.events.exceptions.NotifyEventException;
import java.time.OffsetDateTime;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.json.JSONObject;

public class PagerDutyUtils {
    private static final PagerDutyEventsClient client = PagerDutyEventsClient.create();
    private static CBGConfig config = ConfigUtils.getConfig();
    private static final Logger log = Logger.getLogger(PagerDutyUtils.class.getName());

    public static PagerDutyEventsClient getClient() {
        return client;
    }

    public static void trigger(Level level, String message) {
        String instanceID = config.getInstanceID();
        String serviceKey = config.getPagerdutyServiceKey();
        if (serviceKey == null) {
            log.info("Routing service key was null. Unable to route PagerDuty Incident");
            return;
        }
        Payload payload = Payload.Builder.newBuilder().setSummary(PagerDutyUtils.getSummary(message)).setSource(instanceID).setSeverity(PagerDutyUtils.convertLevelToSeverity(level)).setTimestamp(OffsetDateTime.now()).setCustomDetails(PagerDutyUtils.getCustomDetails(message)).build();
        TriggerIncident incident = TriggerIncident.TriggerIncidentBuilder.newBuilder(serviceKey, payload).build();
        try {
            EventResult event = PagerDutyUtils.getClient().trigger(incident);
            log.info("Triggered PagerDuty event: " + event.toString());
        }
        catch (NotifyEventException e) {
            log.info("Failed to raise PagerDuty notification. " + e.toString());
        }
    }

    public static Severity convertLevelToSeverity(Level level) {
        if (level == Level.WARNING) {
            return Severity.WARNING;
        }
        if (level == Level.SEVERE) {
            return Severity.CRITICAL;
        }
        if (level == Level.INFO) {
            return Severity.INFO;
        }
        if (level == Level.FINE || level == Level.FINER || level == Level.FINEST) {
            return Severity.INFO;
        }
        return Severity.INFO;
    }

    private static JSONObject getCustomDetails(String message) {
        JSONObject details = new JSONObject();
        details.append("Details", message);
        return details;
    }

    private static String getSummary(String message) {
        if (message.length() >= 101) {
            message = message.substring(0, 100);
        }
        return "CBG Binary Encountered Error. See Details for full exception. Partial Message: " + message;
    }
}

