/*
 * Decompiled with CFR 0.152.
 */
package com.github.dikhan.pagerduty.client.events;

import com.github.dikhan.pagerduty.client.events.ApiService;
import com.github.dikhan.pagerduty.client.events.JacksonObjectMapper;
import com.github.dikhan.pagerduty.client.events.domain.EventResult;
import com.github.dikhan.pagerduty.client.events.domain.Incident;
import com.github.dikhan.pagerduty.client.events.exceptions.NotifyEventException;
import com.github.dikhan.pagerduty.client.events.utils.JsonUtils;
import com.mashape.unirest.http.HttpResponse;
import com.mashape.unirest.http.JsonNode;
import com.mashape.unirest.http.Unirest;
import com.mashape.unirest.http.exceptions.UnirestException;
import com.mashape.unirest.request.HttpRequestWithBody;
import java.io.IOException;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpApiServiceImpl
implements ApiService {
    private static final Logger log = LoggerFactory.getLogger(HttpApiServiceImpl.class);
    private final String eventApi;

    public HttpApiServiceImpl(String eventApi) {
        this.eventApi = eventApi;
        this.initUnirest();
    }

    private void initUnirest() {
        Unirest.setObjectMapper(new JacksonObjectMapper());
    }

    @Override
    public EventResult notifyEvent(Incident incident) throws NotifyEventException {
        try {
            HttpRequestWithBody request = Unirest.post(this.eventApi).header("Accept", "application/json");
            request.body(incident);
            HttpResponse<JsonNode> jsonResponse = request.asJson();
            log.debug(IOUtils.toString(jsonResponse.getRawBody()));
            switch (jsonResponse.getStatus()) {
                case 200: 
                case 201: 
                case 202: {
                    return EventResult.successEvent(JsonUtils.getPropertyValue(jsonResponse, "status"), JsonUtils.getPropertyValue(jsonResponse, "message"), JsonUtils.getPropertyValue(jsonResponse, "dedup_key"));
                }
                case 400: {
                    return EventResult.errorEvent(JsonUtils.getPropertyValue(jsonResponse, "status"), JsonUtils.getPropertyValue(jsonResponse, "message"), JsonUtils.getArrayValue(jsonResponse, "errors"));
                }
            }
            return EventResult.errorEvent(String.valueOf(jsonResponse.getStatus()), "", IOUtils.toString(jsonResponse.getRawBody()));
        }
        catch (UnirestException | IOException e) {
            throw new NotifyEventException(e);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HttpApiServiceImpl that = (HttpApiServiceImpl)o;
        return !(this.eventApi == null ? that.eventApi != null : !this.eventApi.equals(that.eventApi));
    }

    public int hashCode() {
        return this.eventApi != null ? this.eventApi.hashCode() : 0;
    }
}

