/*
 * Decompiled with CFR 0.152.
 */
package com.github.dikhan.pagerduty.client.events;

import com.github.dikhan.pagerduty.client.events.ApiService;
import com.github.dikhan.pagerduty.client.events.ApiServiceFactory;
import com.github.dikhan.pagerduty.client.events.domain.AcknowledgeIncident;
import com.github.dikhan.pagerduty.client.events.domain.EventResult;
import com.github.dikhan.pagerduty.client.events.domain.ImageContext;
import com.github.dikhan.pagerduty.client.events.domain.Incident;
import com.github.dikhan.pagerduty.client.events.domain.LinkContext;
import com.github.dikhan.pagerduty.client.events.domain.Payload;
import com.github.dikhan.pagerduty.client.events.domain.ResolveIncident;
import com.github.dikhan.pagerduty.client.events.domain.Severity;
import com.github.dikhan.pagerduty.client.events.domain.TriggerIncident;
import com.github.dikhan.pagerduty.client.events.exceptions.NotifyEventException;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PagerDutyEventsClient {
    private static final Logger log = LoggerFactory.getLogger(PagerDutyEventsClient.class);
    private final ApiService httpApiServiceImpl;

    protected PagerDutyEventsClient(PagerDutyClientBuilder pagerDutyClientBuilder) {
        String eventApi = pagerDutyClientBuilder.getEventApi();
        this.httpApiServiceImpl = new ApiServiceFactory(eventApi).getDefault();
    }

    public static void main(String[] args) throws NotifyEventException {
        String routingKey = "ROUTING_KEY";
        String dedupKey = "DEDUP_KEY";
        PagerDutyEventsClient pagerDutyEventsClient = PagerDutyEventsClient.create();
        JSONObject customDetails = new JSONObject();
        customDetails.put("field", "value1");
        customDetails.put("field2", "value2");
        Payload payload = Payload.Builder.newBuilder().setSummary("This is an incident test to test PagerDutyEventsClient").setSource("testing host").setSeverity(Severity.INFO).setTimestamp(OffsetDateTime.now()).setCustomDetails(customDetails).build();
        ArrayList<ImageContext> imageContextList = new ArrayList<ImageContext>();
        imageContextList.add(new ImageContext("src1"));
        ArrayList<LinkContext> linkContextList = new ArrayList<LinkContext>();
        linkContextList.add(new LinkContext("href", "text"));
        TriggerIncident incident = ((TriggerIncident.TriggerIncidentBuilder)((TriggerIncident.TriggerIncidentBuilder)((TriggerIncident.TriggerIncidentBuilder)TriggerIncident.TriggerIncidentBuilder.newBuilder(routingKey, payload).setDedupKey(dedupKey)).setClient("client").setClientUrl("https://monitoring.example.com").setLinks(linkContextList)).setImages(imageContextList)).build();
        pagerDutyEventsClient.trigger(incident);
        AcknowledgeIncident ack = AcknowledgeIncident.AcknowledgeIncidentBuilder.newBuilder(routingKey, dedupKey).build();
        pagerDutyEventsClient.acknowledge(ack);
        ResolveIncident resolve = ResolveIncident.ResolveIncidentBuilder.newBuilder(routingKey, dedupKey).build();
        pagerDutyEventsClient.resolve(resolve);
    }

    public static PagerDutyEventsClient create() {
        return new PagerDutyClientBuilder().build();
    }

    public static PagerDutyEventsClient create(String eventApi) {
        return new PagerDutyClientBuilder().withEventApi(eventApi).build();
    }

    public EventResult trigger(TriggerIncident incident) throws NotifyEventException {
        EventResult eventResult = this.sendEvent(incident);
        return eventResult;
    }

    public EventResult acknowledge(AcknowledgeIncident ack) throws NotifyEventException {
        EventResult eventResult = this.sendEvent(ack);
        return eventResult;
    }

    public EventResult resolve(ResolveIncident resolve) throws NotifyEventException {
        EventResult eventResult = this.sendEvent(resolve);
        return eventResult;
    }

    private EventResult sendEvent(Incident incident) throws NotifyEventException {
        EventResult eventResult = this.httpApiServiceImpl.notifyEvent(incident);
        log.debug("Event result {} for {}", (Object)eventResult, (Object)incident);
        return eventResult;
    }

    protected static class PagerDutyClientBuilder {
        private static final String PAGER_DUTY_EVENT_API = "https://events.pagerduty.com/v2/enqueue";
        private String eventApi;

        public PagerDutyClientBuilder withEventApi(String eventApi) {
            this.eventApi = eventApi;
            return this;
        }

        public PagerDutyEventsClient build() {
            if (StringUtils.isBlank(this.eventApi)) {
                this.eventApi = PAGER_DUTY_EVENT_API;
            }
            return new PagerDutyEventsClient(this);
        }

        public String getEventApi() {
            return this.eventApi;
        }
    }
}

