/*
 * Decompiled with CFR 0.152.
 */
package com.github.dikhan.pagerduty.client.events.domain;

public class EventResult {
    private final String status;
    private final String message;
    private final String dedupKey;
    private final String errors;

    private EventResult(EventResultBuilder eventResultBuilder) {
        this.status = eventResultBuilder.getStatus();
        this.message = eventResultBuilder.getMessage();
        this.dedupKey = eventResultBuilder.getDedupKey();
        this.errors = eventResultBuilder.getErrors();
    }

    public static EventResult successEvent(String status, String message, String dedupKey) {
        return new EventResultBuilder(status, message).success(dedupKey).build();
    }

    public static EventResult errorEvent(String status, String message, String errors) {
        return new EventResultBuilder(status, message).error(errors).build();
    }

    public String getStatus() {
        return this.status;
    }

    public String getMessage() {
        return this.message;
    }

    public String getDedupKey() {
        return this.dedupKey;
    }

    public String getErrors() {
        return this.errors;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EventResult that = (EventResult)o;
        if (this.status != null ? !this.status.equals(that.status) : that.status != null) {
            return false;
        }
        if (this.message != null ? !this.message.equals(that.message) : that.message != null) {
            return false;
        }
        if (this.dedupKey != null ? !this.dedupKey.equals(that.dedupKey) : that.dedupKey != null) {
            return false;
        }
        return !(this.errors == null ? that.errors != null : !this.errors.equals(that.errors));
    }

    public int hashCode() {
        int result = this.status != null ? this.status.hashCode() : 0;
        result = 31 * result + (this.message != null ? this.message.hashCode() : 0);
        result = 31 * result + (this.dedupKey != null ? this.dedupKey.hashCode() : 0);
        result = 31 * result + (this.errors != null ? this.errors.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "EventResult{status='" + this.status + '\'' + ", message='" + this.message + '\'' + ", dedupKey='" + this.dedupKey + '\'' + ", errors='" + this.errors + '\'' + '}';
    }

    private static class EventResultBuilder {
        private final String status;
        private final String message;
        private String dedupKey;
        private String errors;

        public EventResultBuilder(String status, String message) {
            this.status = status;
            this.message = message;
        }

        public EventResultBuilder success(String dedupKey) {
            this.dedupKey = dedupKey;
            return this;
        }

        public EventResultBuilder error(String errors) {
            this.errors = errors;
            return this;
        }

        public String getStatus() {
            return this.status;
        }

        public String getMessage() {
            return this.message;
        }

        public String getDedupKey() {
            return this.dedupKey;
        }

        public String getErrors() {
            return this.errors;
        }

        public EventResult build() {
            return new EventResult(this);
        }
    }
}

