/*
 * Decompiled with CFR 0.152.
 */
package com.timgroup.statsd;

import com.timgroup.statsd.ConvenienceMethodProvidingStatsDClient;
import com.timgroup.statsd.StatsDClientErrorHandler;
import com.timgroup.statsd.StatsDClientException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetSocketAddress;
import java.nio.charset.Charset;
import java.util.Locale;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

public final class NonBlockingStatsDClient
extends ConvenienceMethodProvidingStatsDClient {
    private static final Charset STATS_D_ENCODING = Charset.forName("UTF-8");
    private static final StatsDClientErrorHandler NO_OP_HANDLER = new StatsDClientErrorHandler(){

        @Override
        public void handle(Exception exception) {
        }
    };
    private final String prefix;
    private final DatagramSocket clientSocket;
    private final StatsDClientErrorHandler handler;
    private final ExecutorService executor = Executors.newSingleThreadExecutor(new ThreadFactory(){
        final ThreadFactory delegate = Executors.defaultThreadFactory();

        @Override
        public Thread newThread(Runnable runnable) {
            Thread thread = this.delegate.newThread(runnable);
            thread.setName("StatsD-" + thread.getName());
            thread.setDaemon(true);
            return thread;
        }
    });

    public NonBlockingStatsDClient(String string, String string2, int n) throws StatsDClientException {
        this(string, string2, n, NO_OP_HANDLER);
    }

    public NonBlockingStatsDClient(String string, String string2, int n, StatsDClientErrorHandler statsDClientErrorHandler) throws StatsDClientException {
        this.prefix = string == null || string.trim().isEmpty() ? "" : string.trim() + ".";
        this.handler = statsDClientErrorHandler;
        try {
            this.clientSocket = new DatagramSocket();
            this.clientSocket.connect(new InetSocketAddress(string2, n));
        }
        catch (Exception exception) {
            throw new StatsDClientException("Failed to start StatsD client", exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        try {
            this.executor.shutdown();
            this.executor.awaitTermination(30L, TimeUnit.SECONDS);
        }
        catch (Exception exception) {
            this.handler.handle(exception);
        }
        finally {
            if (this.clientSocket != null) {
                this.clientSocket.close();
            }
        }
    }

    @Override
    public void count(String string, long l, double d) {
        this.send(this.messageFor(string, l, "c", d));
    }

    @Override
    public void recordGaugeValue(String string, long l) {
        String string2 = this.messageFor(string, l, "g");
        if (l < 0L) {
            string2 = this.messageFor(string, 0, "g") + "\n" + string2;
        }
        this.send(string2);
    }

    @Override
    public void recordGaugeDelta(String string, long l) {
        this.send(this.messageFor(string, l < 0L ? Long.valueOf(l) : "+" + l, "g"));
    }

    @Override
    public void recordSetEvent(String string, String string2) {
        this.send(this.messageFor(string, string2, "s"));
    }

    @Override
    public void recordExecutionTime(String string, long l, double d) {
        this.send(this.messageFor(string, l, "ms", d));
    }

    private String messageFor(String string, Object object, String string2) {
        return this.messageFor(string, object, string2, 1.0);
    }

    private String messageFor(String string, Object object, String string2, double d) {
        String string3 = d == 1.0 ? "%s%s:%s|%s" : "%s%s:%s|%s@%f";
        return String.format((Locale)null, string3, this.prefix, string, object, string2, d);
    }

    private void send(final String string) {
        try {
            this.executor.execute(new Runnable(){

                @Override
                public void run() {
                    NonBlockingStatsDClient.this.blockingSend(string);
                }
            });
        }
        catch (Exception exception) {
            this.handler.handle(exception);
        }
    }

    private void blockingSend(String string) {
        try {
            byte[] byArray = string.getBytes(STATS_D_ENCODING);
            DatagramPacket datagramPacket = new DatagramPacket(byArray, byArray.length);
            this.clientSocket.send(datagramPacket);
        }
        catch (Exception exception) {
            this.handler.handle(exception);
        }
    }
}

