/*
 * Decompiled with CFR 0.152.
 */
package io.github.devatherock.json.formatter.helpers;

import io.github.devatherock.json.formatter.helpers.JsonConverter;
import java.util.Map;

public class CustomJsonConverter
implements JsonConverter {
    private static final String DOUBLE_QUOTE = "\"";
    private static final String COLON = ":";
    private static final String COMMA = ",";
    private static final String OBJ_START = "{";
    private static final String OBJ_END = "}";
    private static final char[] CHARS_TO_ESCAPE = new char[]{'\n', '\r', '\"'};
    private static final String[] ESCAPE_CHARS = new String[]{"\\n", "\\r", "\\\""};
    private static final String LINE_SEP = System.getProperty("line.separator");

    @Override
    public String convertToJson(Map<String, Object> map) {
        StringBuilder log = new StringBuilder();
        log.append(OBJ_START);
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            this.appendJsonObject(entry.getKey(), entry.getValue(), log);
            log.append(COMMA);
        }
        log.replace(log.length() - 1, log.length(), "");
        log.append(OBJ_END);
        log.append(LINE_SEP);
        return log.toString();
    }

    private void appendJson(Object key, Object value, StringBuilder log) {
        log.append(DOUBLE_QUOTE);
        log.append(key);
        log.append(DOUBLE_QUOTE);
        log.append(COLON);
        if (value instanceof String) {
            log.append(DOUBLE_QUOTE);
            log.append(CustomJsonConverter.escapeJson((String)value));
            log.append(DOUBLE_QUOTE);
        } else {
            log.append(value);
        }
    }

    private void appendJsonObject(Object key, Object value, StringBuilder log) {
        if (value instanceof Map) {
            log.append(DOUBLE_QUOTE);
            log.append(key);
            log.append(DOUBLE_QUOTE);
            log.append(COLON);
            log.append(OBJ_START);
            Map map = (Map)value;
            for (Map.Entry entry : map.entrySet()) {
                this.appendJsonObject(entry.getKey(), entry.getValue(), log);
                log.append(COMMA);
            }
            log.replace(log.length() - 1, log.length(), "");
            log.append(OBJ_END);
        } else {
            this.appendJson(key, value, log);
        }
    }

    private static String escapeJson(String message) {
        StringBuilder escapedText = new StringBuilder(message.length());
        boolean notEscaped = true;
        for (int index = 0; index < message.length(); ++index) {
            notEscaped = true;
            char currentChar = message.charAt(index);
            for (int escapeIndex = 0; escapeIndex < CHARS_TO_ESCAPE.length; ++escapeIndex) {
                if (currentChar != CHARS_TO_ESCAPE[escapeIndex]) continue;
                escapedText.append(ESCAPE_CHARS[escapeIndex]);
                notEscaped = false;
                break;
            }
            if (!notEscaped) continue;
            if (currentChar > '\u001f') {
                escapedText.append(currentChar);
                continue;
            }
            escapedText.append(' ');
        }
        return escapedText.toString();
    }
}

