/*
 * Decompiled with CFR 0.152.
 */
package graphql;

import graphql.Assert;
import graphql.Internal;
import graphql.collect.ImmutableKit;
import graphql.com.google.common.collect.ImmutableList;
import graphql.com.google.common.collect.ImmutableMap;
import graphql.schema.GraphQLArgument;
import graphql.schema.GraphQLDirective;
import graphql.util.FpKit;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

@Internal
public class DirectivesUtil {
    public static Map<String, GraphQLDirective> nonRepeatableDirectivesByName(List<GraphQLDirective> directives) {
        List singletonDirectives = directives.stream().filter(d -> !d.isRepeatable()).collect(Collectors.toList());
        return FpKit.getByName(singletonDirectives, GraphQLDirective::getName);
    }

    public static Map<String, ImmutableList<GraphQLDirective>> allDirectivesByName(List<GraphQLDirective> directives) {
        return ImmutableMap.copyOf(FpKit.groupingBy(directives, GraphQLDirective::getName));
    }

    public static GraphQLDirective nonRepeatedDirectiveByNameWithAssert(Map<String, List<GraphQLDirective>> directives, String directiveName) {
        List<GraphQLDirective> directiveList = directives.get(directiveName);
        if (directiveList == null || directiveList.isEmpty()) {
            return null;
        }
        Assert.assertTrue(DirectivesUtil.isAllNonRepeatable(directiveList), () -> String.format("'%s' is a repeatable directive and you have used a non repeatable access method", directiveName));
        return directiveList.get(0);
    }

    public static Optional<GraphQLArgument> directiveWithArg(List<GraphQLDirective> directives, String directiveName, String argumentName) {
        GraphQLDirective directive = DirectivesUtil.nonRepeatableDirectivesByName(directives).get(directiveName);
        GraphQLArgument argument = null;
        if (directive != null) {
            argument = directive.getArgument(argumentName);
        }
        return Optional.ofNullable(argument);
    }

    public static boolean isAllNonRepeatable(List<GraphQLDirective> directives) {
        if (directives == null || directives.isEmpty()) {
            return false;
        }
        for (GraphQLDirective graphQLDirective : directives) {
            if (!graphQLDirective.isRepeatable()) continue;
            return false;
        }
        return true;
    }

    public static List<GraphQLDirective> enforceAdd(List<GraphQLDirective> targetList, GraphQLDirective newDirective) {
        Assert.assertNotNull(targetList, () -> "directive list can't be null");
        Assert.assertNotNull(newDirective, () -> "directive can't be null");
        if (newDirective.isNonRepeatable()) {
            Map<String, ImmutableList<GraphQLDirective>> map = DirectivesUtil.allDirectivesByName(targetList);
            DirectivesUtil.assertNonRepeatable(newDirective, map);
        }
        targetList.add(newDirective);
        return targetList;
    }

    public static List<GraphQLDirective> enforceAddAll(List<GraphQLDirective> targetList, List<GraphQLDirective> newDirectives) {
        Assert.assertNotNull(targetList, () -> "directive list can't be null");
        Assert.assertNotNull(newDirectives, () -> "directive list can't be null");
        Map<String, ImmutableList<GraphQLDirective>> map = DirectivesUtil.allDirectivesByName(targetList);
        for (GraphQLDirective newDirective : newDirectives) {
            DirectivesUtil.assertNonRepeatable(newDirective, map);
            targetList.add(newDirective);
        }
        return targetList;
    }

    private static void assertNonRepeatable(GraphQLDirective directive, Map<String, ImmutableList<GraphQLDirective>> mapOfDirectives) {
        List currentDirectives;
        int currentSize;
        if (directive.isNonRepeatable() && (currentSize = (currentDirectives = (List)mapOfDirectives.getOrDefault(directive.getName(), ImmutableKit.emptyList())).size()) > 0) {
            Assert.assertShouldNeverHappen("%s is a non repeatable directive but there is already one present in this list", directive.getName());
        }
    }

    public static GraphQLDirective getFirstDirective(String name, Map<String, List<GraphQLDirective>> allDirectivesByName) {
        List directives = allDirectivesByName.getOrDefault(name, ImmutableKit.emptyList());
        if (directives.isEmpty()) {
            return null;
        }
        return (GraphQLDirective)directives.get(0);
    }

    public static class DirectivesHolder {
        private final ImmutableMap<String, List<GraphQLDirective>> allDirectivesByName;
        private final ImmutableMap<String, GraphQLDirective> nonRepeatableDirectivesByName;
        private final List<GraphQLDirective> allDirectives;

        public DirectivesHolder(Collection<GraphQLDirective> allDirectives) {
            this.allDirectives = ImmutableList.copyOf(allDirectives);
            this.allDirectivesByName = ImmutableMap.copyOf(FpKit.groupingBy(allDirectives, GraphQLDirective::getName));
            List nonRepeatableDirectives = allDirectives.stream().filter(d -> !d.isRepeatable()).collect(Collectors.toList());
            this.nonRepeatableDirectivesByName = ImmutableMap.copyOf(FpKit.getByName(nonRepeatableDirectives, GraphQLDirective::getName));
        }

        public ImmutableMap<String, List<GraphQLDirective>> getAllDirectivesByName() {
            return this.allDirectivesByName;
        }

        public ImmutableMap<String, GraphQLDirective> getDirectivesByName() {
            return this.nonRepeatableDirectivesByName;
        }

        public List<GraphQLDirective> getDirectives() {
            return this.allDirectives;
        }

        public GraphQLDirective getDirective(String directiveName) {
            List<GraphQLDirective> directiveList = this.allDirectivesByName.get(directiveName);
            if (directiveList == null || directiveList.isEmpty()) {
                return null;
            }
            Assert.assertTrue(DirectivesUtil.isAllNonRepeatable(directiveList), () -> String.format("'%s' is a repeatable directive and you have used a non repeatable access method", directiveName));
            return directiveList.get(0);
        }

        public List<GraphQLDirective> getDirectives(String directiveName) {
            return this.allDirectivesByName.getOrDefault(directiveName, ImmutableKit.emptyList());
        }
    }
}

