/*
 * Decompiled with CFR 0.152.
 */
package graphql.execution;

import graphql.Assert;
import graphql.PublicApi;
import graphql.com.google.common.collect.ImmutableList;
import graphql.language.Argument;
import graphql.language.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;

@PublicApi
public class MergedField {
    private final ImmutableList<Field> fields;
    private final Field singleField;
    private final String name;
    private final String resultKey;

    private MergedField(List<Field> fields) {
        Assert.assertNotEmpty(fields);
        this.fields = ImmutableList.copyOf(fields);
        this.singleField = fields.get(0);
        this.name = this.singleField.getName();
        this.resultKey = this.singleField.getAlias() != null ? this.singleField.getAlias() : this.name;
    }

    public String getName() {
        return this.name;
    }

    public String getResultKey() {
        return this.resultKey;
    }

    public Field getSingleField() {
        return this.singleField;
    }

    public List<Argument> getArguments() {
        return this.singleField.getArguments();
    }

    public List<Field> getFields() {
        return this.fields;
    }

    public static Builder newMergedField() {
        return new Builder();
    }

    public static Builder newMergedField(Field field) {
        return new Builder().addField(field);
    }

    public static Builder newMergedField(List<Field> fields) {
        return new Builder().fields(fields);
    }

    public MergedField transform(Consumer<Builder> builderConsumer) {
        Builder builder = new Builder(this);
        builderConsumer.accept(builder);
        return builder.build();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MergedField that = (MergedField)o;
        return this.fields.equals(that.fields);
    }

    public int hashCode() {
        return Objects.hash(this.fields);
    }

    public String toString() {
        return "MergedField{fields=" + this.fields + '}';
    }

    public static class Builder {
        private final List<Field> fields;

        private Builder() {
            this.fields = new ArrayList<Field>();
        }

        private Builder(MergedField existing) {
            this.fields = new ArrayList<Field>(existing.getFields());
        }

        public Builder fields(List<Field> fields) {
            this.fields.addAll(fields);
            return this;
        }

        public Builder addField(Field field) {
            this.fields.add(field);
            return this;
        }

        public MergedField build() {
            return new MergedField(this.fields);
        }
    }
}

