/*
 * Decompiled with CFR 0.152.
 */
package graphql.execution.nextgen;

import graphql.Assert;
import graphql.ExceptionWhileDataFetching;
import graphql.GraphQLError;
import graphql.Internal;
import graphql.collect.ImmutableKit;
import graphql.com.google.common.collect.ImmutableList;
import graphql.execution.Async;
import graphql.execution.DataFetcherResult;
import graphql.execution.DefaultValueUnboxer;
import graphql.execution.ExecutionContext;
import graphql.execution.ExecutionId;
import graphql.execution.ExecutionStepInfo;
import graphql.execution.FetchedValue;
import graphql.execution.MergedField;
import graphql.execution.ResultPath;
import graphql.execution.ValuesResolver;
import graphql.execution.directives.QueryDirectivesImpl;
import graphql.execution.nextgen.BatchedDataFetcher;
import graphql.execution.nextgen.ExecutionStrategy;
import graphql.language.Field;
import graphql.normalized.NormalizedField;
import graphql.normalized.NormalizedQueryTree;
import graphql.schema.DataFetcher;
import graphql.schema.DataFetchingEnvironment;
import graphql.schema.DataFetchingEnvironmentImpl;
import graphql.schema.DataFetchingFieldSelectionSet;
import graphql.schema.DataFetchingFieldSelectionSetImpl;
import graphql.schema.GraphQLCodeRegistry;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLFieldsContainer;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLTypeUtil;
import graphql.util.FpKit;
import graphql.util.LogKit;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public class ValueFetcher {
    ValuesResolver valuesResolver = new ValuesResolver();
    private static final Logger log = LoggerFactory.getLogger(ValueFetcher.class);
    private static final Logger logNotSafe = LogKit.getNotPrivacySafeLogger(ExecutionStrategy.class);
    public static final Object NULL_VALUE = new Object();

    public CompletableFuture<List<FetchedValue>> fetchBatchedValues(ExecutionContext executionContext, List<Object> sources, MergedField field, List<ExecutionStepInfo> executionInfos) {
        ExecutionStepInfo executionStepInfo = executionInfos.get(0);
        Object todoLocalContext = null;
        if (this.isDataFetcherBatched(executionContext, executionStepInfo)) {
            return this.fetchValue(executionContext, sources, todoLocalContext, field, executionStepInfo).thenApply(fetchedValue -> this.extractBatchedValues((FetchedValue)fetchedValue, sources.size()));
        }
        ArrayList fetchedValues = new ArrayList();
        for (int i = 0; i < sources.size(); ++i) {
            fetchedValues.add(this.fetchValue(executionContext, sources.get(i), todoLocalContext, field, executionInfos.get(i)));
        }
        return Async.each(fetchedValues);
    }

    private List<FetchedValue> extractBatchedValues(FetchedValue fetchedValueContainingList, int expectedSize) {
        List list = (List)fetchedValueContainingList.getFetchedValue();
        Assert.assertTrue(list.size() == expectedSize, () -> "Unexpected result size");
        ArrayList<FetchedValue> result = new ArrayList<FetchedValue>();
        for (int i = 0; i < list.size(); ++i) {
            List<GraphQLError> errors = i == 0 ? fetchedValueContainingList.getErrors() : Collections.emptyList();
            FetchedValue fetchedValue = FetchedValue.newFetchedValue().fetchedValue(list.get(i)).rawFetchedValue(fetchedValueContainingList.getRawFetchedValue()).errors(errors).localContext(fetchedValueContainingList.getLocalContext()).build();
            result.add(fetchedValue);
        }
        return result;
    }

    private GraphQLFieldsContainer getFieldsContainer(ExecutionStepInfo executionStepInfo) {
        GraphQLOutputType type = executionStepInfo.getParent().getType();
        return (GraphQLFieldsContainer)((Object)GraphQLTypeUtil.unwrapAll(type));
    }

    private boolean isDataFetcherBatched(ExecutionContext executionContext, ExecutionStepInfo executionStepInfo) {
        GraphQLFieldsContainer parentType = this.getFieldsContainer(executionStepInfo);
        GraphQLFieldDefinition fieldDef = executionStepInfo.getFieldDefinition();
        DataFetcher<?> dataFetcher = executionContext.getGraphQLSchema().getCodeRegistry().getDataFetcher(parentType, fieldDef);
        return dataFetcher instanceof BatchedDataFetcher;
    }

    public CompletableFuture<FetchedValue> fetchValue(ExecutionContext executionContext, Object source, Object localContext, MergedField sameFields, ExecutionStepInfo executionInfo) {
        Field field = sameFields.getSingleField();
        GraphQLFieldDefinition fieldDef = executionInfo.getFieldDefinition();
        GraphQLCodeRegistry codeRegistry = executionContext.getGraphQLSchema().getCodeRegistry();
        GraphQLFieldsContainer parentType = this.getFieldsContainer(executionInfo);
        Supplier<Map<String, Object>> argumentValues = FpKit.intraThreadMemoize(() -> this.valuesResolver.getArgumentValues(codeRegistry, fieldDef.getArguments(), field.getArguments(), executionContext.getVariables()));
        QueryDirectivesImpl queryDirectives = new QueryDirectivesImpl(sameFields, executionContext.getGraphQLSchema(), executionContext.getVariables());
        GraphQLOutputType fieldType = fieldDef.getType();
        Supplier<NormalizedQueryTree> normalizedQuery = executionContext.getNormalizedQueryTree();
        Supplier<NormalizedField> normalisedField = () -> ((NormalizedQueryTree)normalizedQuery.get()).getNormalizedField(sameFields, executionInfo.getObjectType(), executionInfo.getPath());
        DataFetchingFieldSelectionSet selectionSet = DataFetchingFieldSelectionSetImpl.newCollector(fieldType, normalisedField);
        DataFetchingEnvironment environment = DataFetchingEnvironmentImpl.newDataFetchingEnvironment(executionContext).source(source).localContext(localContext).arguments(argumentValues).fieldDefinition(fieldDef).mergedField(sameFields).fieldType(fieldType).executionStepInfo(executionInfo).parentType(parentType).selectionSet(selectionSet).queryDirectives(queryDirectives).build();
        ExecutionId executionId = executionContext.getExecutionId();
        ResultPath path = executionInfo.getPath();
        return ((CompletableFuture)((CompletableFuture)((CompletableFuture)this.callDataFetcher(codeRegistry, parentType, fieldDef, environment, executionId, path).thenApply(rawFetchedValue -> FetchedValue.newFetchedValue().fetchedValue(rawFetchedValue).rawFetchedValue(rawFetchedValue).build())).exceptionally(exception -> this.handleExceptionWhileFetching(field, path, (Throwable)exception))).thenApply(result -> this.unboxPossibleDataFetcherResult(sameFields, path, (FetchedValue)result, localContext))).thenApply(this::unboxPossibleOptional);
    }

    private FetchedValue handleExceptionWhileFetching(Field field, ResultPath path, Throwable exception) {
        ExceptionWhileDataFetching exceptionWhileDataFetching = new ExceptionWhileDataFetching(path, exception, field.getSourceLocation());
        return FetchedValue.newFetchedValue().errors(Collections.singletonList(exceptionWhileDataFetching)).build();
    }

    private FetchedValue unboxPossibleOptional(FetchedValue result) {
        return result.transform(builder -> builder.fetchedValue(DefaultValueUnboxer.unboxValue(result.getFetchedValue())));
    }

    private CompletableFuture<Object> callDataFetcher(GraphQLCodeRegistry codeRegistry, GraphQLFieldsContainer parentType, GraphQLFieldDefinition fieldDef, DataFetchingEnvironment environment, ExecutionId executionId, ResultPath path) {
        CompletableFuture<Object> result = new CompletableFuture<Object>();
        try {
            DataFetcher<?> dataFetcher = codeRegistry.getDataFetcher(parentType, fieldDef);
            if (log.isDebugEnabled()) {
                log.debug("'{}' fetching field '{}' using data fetcher '{}'...", executionId, path, dataFetcher.getClass().getName());
            }
            Object fetchedValueRaw = dataFetcher.get(environment);
            if (logNotSafe.isDebugEnabled()) {
                logNotSafe.debug("'{}' field '{}' fetch returned '{}'", executionId, path, fetchedValueRaw == null ? "null" : fetchedValueRaw.getClass().getName());
            }
            this.handleFetchedValue(fetchedValueRaw, result);
        }
        catch (Exception e) {
            if (logNotSafe.isDebugEnabled()) {
                logNotSafe.debug("'{}', field '{}' fetch threw exception", executionId, path, e);
            }
            result.completeExceptionally(e);
        }
        return result;
    }

    private void handleFetchedValue(Object fetchedValue, CompletableFuture<Object> cf) {
        if (fetchedValue == null) {
            cf.complete(NULL_VALUE);
            return;
        }
        if (fetchedValue instanceof CompletionStage) {
            CompletionStage stage = (CompletionStage)fetchedValue;
            stage.whenComplete((value, throwable) -> {
                if (throwable != null) {
                    cf.completeExceptionally((Throwable)throwable);
                } else {
                    cf.complete(value);
                }
            });
            return;
        }
        cf.complete(fetchedValue);
    }

    private FetchedValue unboxPossibleDataFetcherResult(MergedField sameField, ResultPath resultPath, FetchedValue result, Object localContext) {
        if (result.getFetchedValue() instanceof DataFetcherResult) {
            DataFetcherResult dataFetcherResult = (DataFetcherResult)result.getFetchedValue();
            ImmutableList<GraphQLError> addErrors = ImmutableList.copyOf(dataFetcherResult.getErrors());
            ImmutableList<GraphQLError> newErrors = ImmutableKit.concatLists(result.getErrors(), addErrors);
            Object newLocalContext = dataFetcherResult.getLocalContext();
            if (newLocalContext == null) {
                newLocalContext = localContext;
            }
            return FetchedValue.newFetchedValue().fetchedValue(dataFetcherResult.getData()).rawFetchedValue(result.getRawFetchedValue()).errors(newErrors).localContext(newLocalContext).build();
        }
        return result;
    }
}

