/*
 * Decompiled with CFR 0.152.
 */
package graphql.execution.nextgen.result;

import graphql.Assert;
import graphql.GraphQLError;
import graphql.Internal;
import graphql.com.google.common.collect.ImmutableList;
import graphql.execution.ExecutionStepInfo;
import graphql.execution.MergedField;
import graphql.execution.NonNullableFieldWasNullException;
import graphql.execution.nextgen.result.ResolvedValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;

@Internal
public abstract class ExecutionResultNode {
    private final ExecutionStepInfo executionStepInfo;
    private final ResolvedValue resolvedValue;
    private final NonNullableFieldWasNullException nonNullableFieldWasNullException;
    private final ImmutableList<ExecutionResultNode> children;
    private final ImmutableList<GraphQLError> errors;

    protected ExecutionResultNode(ExecutionStepInfo executionStepInfo, ResolvedValue resolvedValue, NonNullableFieldWasNullException nonNullableFieldWasNullException, List<ExecutionResultNode> children, List<GraphQLError> errors) {
        this.resolvedValue = resolvedValue;
        this.executionStepInfo = executionStepInfo;
        this.nonNullableFieldWasNullException = nonNullableFieldWasNullException;
        this.children = ImmutableList.copyOf((Collection)Assert.assertNotNull(children));
        children.forEach(Assert::assertNotNull);
        this.errors = ImmutableList.copyOf(errors);
    }

    public List<GraphQLError> getErrors() {
        return new ArrayList<GraphQLError>(this.errors);
    }

    public ResolvedValue getResolvedValue() {
        return this.resolvedValue;
    }

    public MergedField getMergedField() {
        return this.executionStepInfo.getField();
    }

    public ExecutionStepInfo getExecutionStepInfo() {
        return this.executionStepInfo;
    }

    public NonNullableFieldWasNullException getNonNullableFieldWasNullException() {
        return this.nonNullableFieldWasNullException;
    }

    public List<ExecutionResultNode> getChildren() {
        return this.children;
    }

    public Optional<NonNullableFieldWasNullException> getChildNonNullableException() {
        return this.children.stream().filter(executionResultNode -> executionResultNode.getNonNullableFieldWasNullException() != null).map(ExecutionResultNode::getNonNullableFieldWasNullException).findFirst();
    }

    public abstract ExecutionResultNode withNewChildren(List<ExecutionResultNode> var1);

    public abstract ExecutionResultNode withNewResolvedValue(ResolvedValue var1);

    public abstract ExecutionResultNode withNewExecutionStepInfo(ExecutionStepInfo var1);

    public abstract ExecutionResultNode withNewErrors(List<GraphQLError> var1);

    public String toString() {
        return "ExecutionResultNode{executionStepInfo=" + this.executionStepInfo + ", resolvedValue=" + this.resolvedValue + ", nonNullableFieldWasNullException=" + this.nonNullableFieldWasNullException + ", children=" + this.children + ", errors=" + this.errors + '}';
    }
}

