/*
 * Decompiled with CFR 0.152.
 */
package graphql.execution.reactive;

import graphql.Internal;
import graphql.execution.reactive.DelegatingSubscription;
import java.util.ArrayDeque;
import java.util.Queue;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

@Internal
public class CompletionStageMappingPublisher<D, U>
implements Publisher<D> {
    private final Publisher<U> upstreamPublisher;
    private final Function<U, CompletionStage<D>> mapper;

    public CompletionStageMappingPublisher(Publisher<U> upstreamPublisher, Function<U, CompletionStage<D>> mapper) {
        this.upstreamPublisher = upstreamPublisher;
        this.mapper = mapper;
    }

    @Override
    public void subscribe(final Subscriber<? super D> downstreamSubscriber) {
        this.upstreamPublisher.subscribe(new Subscriber<U>(){
            Subscription delegatingSubscription;
            final Queue<CompletionStage<?>> inFlightDataQ = new ArrayDeque();
            final AtomicReference<Runnable> onCompleteOrErrorRun = new AtomicReference();
            final AtomicBoolean onCompleteOrErrorRunCalled = new AtomicBoolean(false);

            @Override
            public void onSubscribe(Subscription subscription) {
                this.delegatingSubscription = new DelegatingSubscription(subscription);
                downstreamSubscriber.onSubscribe(this.delegatingSubscription);
            }

            @Override
            public void onNext(U u) {
                if (this.onCompleteOrErrorRunCalled.get()) {
                    return;
                }
                try {
                    CompletionStage completionStage = (CompletionStage)CompletionStageMappingPublisher.this.mapper.apply(u);
                    this.offerToInFlightQ(completionStage);
                    completionStage.whenComplete(this.whenNextFinished(completionStage));
                }
                catch (RuntimeException throwable) {
                    this.handleThrowable(throwable);
                }
            }

            private BiConsumer<D, Throwable> whenNextFinished(CompletionStage<D> completionStage) {
                return (d, throwable) -> {
                    try {
                        if (throwable != null) {
                            this.handleThrowable((Throwable)throwable);
                        } else {
                            downstreamSubscriber.onNext(d);
                        }
                    }
                    finally {
                        Runnable runOnCompleteOrErrorRun = this.onCompleteOrErrorRun.get();
                        boolean empty = this.removeFromInFlightQAndCheckIfEmpty(completionStage);
                        if (empty && runOnCompleteOrErrorRun != null) {
                            this.onCompleteOrErrorRun.set(null);
                            runOnCompleteOrErrorRun.run();
                        }
                    }
                };
            }

            private void handleThrowable(Throwable throwable) {
                downstreamSubscriber.onError(throwable);
                this.delegatingSubscription.cancel();
            }

            @Override
            public void onError(Throwable t) {
                this.onCompleteOrError(() -> {
                    this.onCompleteOrErrorRunCalled.set(true);
                    downstreamSubscriber.onError(t);
                });
            }

            @Override
            public void onComplete() {
                this.onCompleteOrError(() -> {
                    this.onCompleteOrErrorRunCalled.set(true);
                    downstreamSubscriber.onComplete();
                });
            }

            private void onCompleteOrError(Runnable doneCodeToRun) {
                if (this.inFlightQIsEmpty()) {
                    doneCodeToRun.run();
                } else {
                    this.onCompleteOrErrorRun.set(doneCodeToRun);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void offerToInFlightQ(CompletionStage<?> completionStage) {
                Queue<CompletionStage<?>> queue = this.inFlightDataQ;
                synchronized (queue) {
                    this.inFlightDataQ.offer(completionStage);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private boolean removeFromInFlightQAndCheckIfEmpty(CompletionStage<?> completionStage) {
                Queue<CompletionStage<?>> queue = this.inFlightDataQ;
                synchronized (queue) {
                    this.inFlightDataQ.remove(completionStage);
                    return this.inFlightDataQ.isEmpty();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private boolean inFlightQIsEmpty() {
                Queue<CompletionStage<?>> queue = this.inFlightDataQ;
                synchronized (queue) {
                    return this.inFlightDataQ.isEmpty();
                }
            }
        });
    }
}

