/*
 * Decompiled with CFR 0.152.
 */
package graphql.introspection;

import graphql.Assert;
import graphql.Internal;
import graphql.PublicApi;
import graphql.Scalars;
import graphql.introspection.IntrospectionDataFetcher;
import graphql.introspection.IntrospectionDataFetchingEnvironment;
import graphql.language.AstPrinter;
import graphql.language.AstValueHelper;
import graphql.schema.DataFetcher;
import graphql.schema.FieldCoordinates;
import graphql.schema.GraphQLArgument;
import graphql.schema.GraphQLCodeRegistry;
import graphql.schema.GraphQLCompositeType;
import graphql.schema.GraphQLDirective;
import graphql.schema.GraphQLEnumType;
import graphql.schema.GraphQLEnumValueDefinition;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLFieldsContainer;
import graphql.schema.GraphQLInputObjectField;
import graphql.schema.GraphQLInputObjectType;
import graphql.schema.GraphQLInputType;
import graphql.schema.GraphQLInterfaceType;
import graphql.schema.GraphQLList;
import graphql.schema.GraphQLModifiedType;
import graphql.schema.GraphQLNamedSchemaElement;
import graphql.schema.GraphQLNamedType;
import graphql.schema.GraphQLNonNull;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLScalarType;
import graphql.schema.GraphQLSchema;
import graphql.schema.GraphQLTypeReference;
import graphql.schema.GraphQLTypeUtil;
import graphql.schema.GraphQLUnionType;
import graphql.schema.visibility.GraphqlFieldVisibility;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

@PublicApi
public class Introspection {
    private static final Map<FieldCoordinates, IntrospectionDataFetcher> introspectionDataFetchers = new LinkedHashMap<FieldCoordinates, IntrospectionDataFetcher>();
    private static final Set<GraphQLNamedType> introspectionTypes = new HashSet<GraphQLNamedType>();
    public static final GraphQLEnumType __TypeKind = GraphQLEnumType.newEnum().name("__TypeKind").description("An enum describing what kind of type a given __Type is").value("SCALAR", (Object)TypeKind.SCALAR, "Indicates this type is a scalar. 'specifiedByUrl' is a valid field").value("OBJECT", (Object)TypeKind.OBJECT, "Indicates this type is an object. `fields` and `interfaces` are valid fields.").value("INTERFACE", (Object)TypeKind.INTERFACE, "Indicates this type is an interface. `fields` and `possibleTypes` are valid fields.").value("UNION", (Object)TypeKind.UNION, "Indicates this type is a union. `possibleTypes` is a valid field.").value("ENUM", (Object)TypeKind.ENUM, "Indicates this type is an enum. `enumValues` is a valid field.").value("INPUT_OBJECT", (Object)TypeKind.INPUT_OBJECT, "Indicates this type is an input object. `inputFields` is a valid field.").value("LIST", (Object)TypeKind.LIST, "Indicates this type is a list. `ofType` is a valid field.").value("NON_NULL", (Object)TypeKind.NON_NULL, "Indicates this type is a non-null. `ofType` is a valid field.").build();
    private static final IntrospectionDataFetcher kindDataFetcher = environment -> {
        Object type = environment.getSource();
        if (type instanceof GraphQLScalarType) {
            return TypeKind.SCALAR;
        }
        if (type instanceof GraphQLObjectType) {
            return TypeKind.OBJECT;
        }
        if (type instanceof GraphQLInterfaceType) {
            return TypeKind.INTERFACE;
        }
        if (type instanceof GraphQLUnionType) {
            return TypeKind.UNION;
        }
        if (type instanceof GraphQLEnumType) {
            return TypeKind.ENUM;
        }
        if (type instanceof GraphQLInputObjectType) {
            return TypeKind.INPUT_OBJECT;
        }
        if (type instanceof GraphQLList) {
            return TypeKind.LIST;
        }
        if (type instanceof GraphQLNonNull) {
            return TypeKind.NON_NULL;
        }
        return Assert.assertShouldNeverHappen("Unknown kind of type: %s", type);
    };
    private static final IntrospectionDataFetcher nameDataFetcher = environment -> {
        Object type = environment.getSource();
        if (type instanceof GraphQLNamedSchemaElement) {
            return ((GraphQLNamedSchemaElement)type).getName();
        }
        return null;
    };
    private static final IntrospectionDataFetcher descriptionDataFetcher = environment -> {
        Object type = environment.getSource();
        if (type instanceof GraphQLNamedSchemaElement) {
            return ((GraphQLNamedSchemaElement)type).getDescription();
        }
        return null;
    };
    public static final GraphQLObjectType __InputValue = GraphQLObjectType.newObject().name("__InputValue").field(GraphQLFieldDefinition.newFieldDefinition().name("name").type(GraphQLNonNull.nonNull(Scalars.GraphQLString))).field(GraphQLFieldDefinition.newFieldDefinition().name("description").type(Scalars.GraphQLString)).field(GraphQLFieldDefinition.newFieldDefinition().name("type").type(GraphQLNonNull.nonNull(GraphQLTypeReference.typeRef("__Type")))).field(GraphQLFieldDefinition.newFieldDefinition().name("defaultValue").type(Scalars.GraphQLString)).build();
    public static final GraphQLObjectType __Field;
    public static final GraphQLObjectType __EnumValue;
    private static final IntrospectionDataFetcher fieldsFetcher;
    private static final IntrospectionDataFetcher interfacesFetcher;
    private static final IntrospectionDataFetcher possibleTypesFetcher;
    private static final IntrospectionDataFetcher enumValuesTypesFetcher;
    private static final IntrospectionDataFetcher inputFieldsFetcher;
    private static final IntrospectionDataFetcher OfTypeFetcher;
    private static final IntrospectionDataFetcher specifiedByUrlDataFetcher;
    public static final GraphQLObjectType __Type;
    public static final GraphQLEnumType __DirectiveLocation;
    public static final GraphQLObjectType __Directive;
    public static final GraphQLObjectType __Schema;
    public static final IntrospectionDataFetcher SchemaMetaFieldDefDataFetcher;
    public static final GraphQLFieldDefinition SchemaMetaFieldDef;
    public static final IntrospectionDataFetcher TypeMetaFieldDefDataFetcher;
    public static final GraphQLFieldDefinition TypeMetaFieldDef;
    public static final IntrospectionDataFetcher TypeNameMetaFieldDefDataFetcher;
    public static final GraphQLFieldDefinition TypeNameMetaFieldDef;
    private static final GraphQLObjectType IntrospectionQuery;

    private static void register(GraphQLFieldsContainer parentType, String fieldName, IntrospectionDataFetcher introspectionDataFetcher) {
        introspectionDataFetchers.put(FieldCoordinates.coordinates(parentType.getName(), fieldName), introspectionDataFetcher);
    }

    @Internal
    public static void addCodeForIntrospectionTypes(GraphQLCodeRegistry.Builder codeRegistry) {
        codeRegistry.systemDataFetcher(FieldCoordinates.systemCoordinates(SchemaMetaFieldDef.getName()), SchemaMetaFieldDefDataFetcher);
        codeRegistry.systemDataFetcher(FieldCoordinates.systemCoordinates(TypeNameMetaFieldDef.getName()), TypeNameMetaFieldDefDataFetcher);
        codeRegistry.systemDataFetcher(FieldCoordinates.systemCoordinates(TypeMetaFieldDef.getName()), TypeMetaFieldDefDataFetcher);
        introspectionDataFetchers.forEach((coordinates, idf) -> codeRegistry.dataFetcher((FieldCoordinates)coordinates, (DataFetcher<?>)idf));
    }

    private static String print(Object value, GraphQLInputType type) {
        return AstPrinter.printAst(AstValueHelper.astFromValue(value, type));
    }

    public static boolean isIntrospectionTypes(GraphQLNamedType type) {
        return introspectionTypes.contains(type);
    }

    public static GraphQLFieldDefinition getFieldDef(GraphQLSchema schema, GraphQLCompositeType parentType, String fieldName) {
        if (schema.getQueryType() == parentType) {
            if (fieldName.equals(SchemaMetaFieldDef.getName())) {
                return SchemaMetaFieldDef;
            }
            if (fieldName.equals(TypeMetaFieldDef.getName())) {
                return TypeMetaFieldDef;
            }
        }
        if (fieldName.equals(TypeNameMetaFieldDef.getName())) {
            return TypeNameMetaFieldDef;
        }
        Assert.assertTrue(parentType instanceof GraphQLFieldsContainer, () -> String.format("should not happen : parent type must be an object or interface %s", parentType));
        GraphQLFieldsContainer fieldsContainer = (GraphQLFieldsContainer)parentType;
        GraphQLFieldDefinition fieldDefinition = schema.getCodeRegistry().getFieldVisibility().getFieldDefinition(fieldsContainer, fieldName);
        Assert.assertTrue(fieldDefinition != null, () -> String.format("Unknown field '%s'", fieldName));
        return fieldDefinition;
    }

    static {
        Introspection.register(__InputValue, "defaultValue", environment -> {
            if (environment.getSource() instanceof GraphQLArgument) {
                GraphQLArgument inputField = (GraphQLArgument)environment.getSource();
                return inputField.getDefaultValue() != null ? Introspection.print(inputField.getDefaultValue(), inputField.getType()) : null;
            }
            if (environment.getSource() instanceof GraphQLInputObjectField) {
                GraphQLInputObjectField inputField = (GraphQLInputObjectField)environment.getSource();
                return inputField.getDefaultValue() != null ? Introspection.print(inputField.getDefaultValue(), inputField.getType()) : null;
            }
            return null;
        });
        Introspection.register(__InputValue, "name", nameDataFetcher);
        Introspection.register(__InputValue, "description", descriptionDataFetcher);
        __Field = GraphQLObjectType.newObject().name("__Field").field(GraphQLFieldDefinition.newFieldDefinition().name("name").type(GraphQLNonNull.nonNull(Scalars.GraphQLString))).field(GraphQLFieldDefinition.newFieldDefinition().name("description").type(Scalars.GraphQLString)).field(GraphQLFieldDefinition.newFieldDefinition().name("args").type(GraphQLNonNull.nonNull(GraphQLList.list(GraphQLNonNull.nonNull(__InputValue))))).field(GraphQLFieldDefinition.newFieldDefinition().name("type").type(GraphQLNonNull.nonNull(GraphQLTypeReference.typeRef("__Type")))).field(GraphQLFieldDefinition.newFieldDefinition().name("isDeprecated").type(GraphQLNonNull.nonNull(Scalars.GraphQLBoolean))).field(GraphQLFieldDefinition.newFieldDefinition().name("deprecationReason").type(Scalars.GraphQLString)).build();
        Introspection.register(__Field, "args", environment -> {
            Object type = environment.getSource();
            return ((GraphQLFieldDefinition)type).getArguments();
        });
        Introspection.register(__Field, "isDeprecated", environment -> {
            Object type = environment.getSource();
            return ((GraphQLFieldDefinition)type).isDeprecated();
        });
        Introspection.register(__Field, "name", nameDataFetcher);
        Introspection.register(__Field, "description", descriptionDataFetcher);
        __EnumValue = GraphQLObjectType.newObject().name("__EnumValue").field(GraphQLFieldDefinition.newFieldDefinition().name("name").type(GraphQLNonNull.nonNull(Scalars.GraphQLString))).field(GraphQLFieldDefinition.newFieldDefinition().name("description").type(Scalars.GraphQLString)).field(GraphQLFieldDefinition.newFieldDefinition().name("isDeprecated").type(GraphQLNonNull.nonNull(Scalars.GraphQLBoolean))).field(GraphQLFieldDefinition.newFieldDefinition().name("deprecationReason").type(Scalars.GraphQLString)).build();
        Introspection.register(__EnumValue, "isDeprecated", environment -> {
            GraphQLEnumValueDefinition enumValue = (GraphQLEnumValueDefinition)environment.getSource();
            return enumValue.isDeprecated();
        });
        Introspection.register(__EnumValue, "name", nameDataFetcher);
        Introspection.register(__EnumValue, "description", descriptionDataFetcher);
        fieldsFetcher = environment -> {
            Object type = environment.getSource();
            Boolean includeDeprecated = (Boolean)environment.getArgument("includeDeprecated");
            if (type instanceof GraphQLFieldsContainer) {
                GraphQLFieldsContainer fieldsContainer = (GraphQLFieldsContainer)type;
                List<GraphQLFieldDefinition> fieldDefinitions = environment.getGraphQLSchema().getFieldVisibility().getFieldDefinitions(fieldsContainer);
                if (includeDeprecated.booleanValue()) {
                    return fieldDefinitions;
                }
                ArrayList<GraphQLFieldDefinition> filtered = new ArrayList<GraphQLFieldDefinition>(fieldDefinitions);
                for (GraphQLFieldDefinition fieldDefinition : fieldDefinitions) {
                    if (!fieldDefinition.isDeprecated()) continue;
                    filtered.remove(fieldDefinition);
                }
                return filtered;
            }
            return null;
        };
        interfacesFetcher = environment -> {
            Object type = environment.getSource();
            if (type instanceof GraphQLObjectType) {
                return ((GraphQLObjectType)type).getInterfaces();
            }
            if (type instanceof GraphQLInterfaceType) {
                return ((GraphQLInterfaceType)type).getInterfaces();
            }
            return null;
        };
        possibleTypesFetcher = environment -> {
            Object type = environment.getSource();
            if (type instanceof GraphQLInterfaceType) {
                return environment.getGraphQLSchema().getImplementations((GraphQLInterfaceType)type);
            }
            if (type instanceof GraphQLUnionType) {
                return ((GraphQLUnionType)type).getTypes();
            }
            return null;
        };
        enumValuesTypesFetcher = environment -> {
            Object type = environment.getSource();
            Boolean includeDeprecated = (Boolean)environment.getArgument("includeDeprecated");
            if (type instanceof GraphQLEnumType) {
                List<GraphQLEnumValueDefinition> values = ((GraphQLEnumType)type).getValues();
                if (includeDeprecated.booleanValue()) {
                    return values;
                }
                ArrayList<GraphQLEnumValueDefinition> filtered = new ArrayList<GraphQLEnumValueDefinition>(values);
                for (GraphQLEnumValueDefinition valueDefinition : values) {
                    if (!valueDefinition.isDeprecated()) continue;
                    filtered.remove(valueDefinition);
                }
                return filtered;
            }
            return null;
        };
        inputFieldsFetcher = environment -> {
            Object type = environment.getSource();
            if (type instanceof GraphQLInputObjectType) {
                GraphqlFieldVisibility fieldVisibility = environment.getGraphQLSchema().getFieldVisibility();
                return fieldVisibility.getFieldDefinitions((GraphQLInputObjectType)type);
            }
            return null;
        };
        OfTypeFetcher = environment -> {
            Object type = environment.getSource();
            if (type instanceof GraphQLModifiedType) {
                return GraphQLTypeUtil.unwrapOne((GraphQLModifiedType)type);
            }
            return null;
        };
        specifiedByUrlDataFetcher = environment -> {
            Object type = environment.getSource();
            if (type instanceof GraphQLScalarType) {
                return ((GraphQLScalarType)type).getSpecifiedByUrl();
            }
            return null;
        };
        __Type = GraphQLObjectType.newObject().name("__Type").field(GraphQLFieldDefinition.newFieldDefinition().name("kind").type(GraphQLNonNull.nonNull(__TypeKind))).field(GraphQLFieldDefinition.newFieldDefinition().name("name").type(Scalars.GraphQLString)).field(GraphQLFieldDefinition.newFieldDefinition().name("description").type(Scalars.GraphQLString)).field(GraphQLFieldDefinition.newFieldDefinition().name("fields").type(GraphQLList.list(GraphQLNonNull.nonNull(__Field))).argument(GraphQLArgument.newArgument().name("includeDeprecated").type(Scalars.GraphQLBoolean).defaultValue(false))).field(GraphQLFieldDefinition.newFieldDefinition().name("interfaces").type(GraphQLList.list(GraphQLNonNull.nonNull(GraphQLTypeReference.typeRef("__Type"))))).field(GraphQLFieldDefinition.newFieldDefinition().name("possibleTypes").type(GraphQLList.list(GraphQLNonNull.nonNull(GraphQLTypeReference.typeRef("__Type"))))).field(GraphQLFieldDefinition.newFieldDefinition().name("enumValues").type(GraphQLList.list(GraphQLNonNull.nonNull(__EnumValue))).argument(GraphQLArgument.newArgument().name("includeDeprecated").type(Scalars.GraphQLBoolean).defaultValue(false))).field(GraphQLFieldDefinition.newFieldDefinition().name("inputFields").type(GraphQLList.list(GraphQLNonNull.nonNull(__InputValue)))).field(GraphQLFieldDefinition.newFieldDefinition().name("ofType").type(GraphQLTypeReference.typeRef("__Type"))).field(GraphQLFieldDefinition.newFieldDefinition().name("specifiedByUrl").type(Scalars.GraphQLString)).build();
        Introspection.register(__Type, "kind", kindDataFetcher);
        Introspection.register(__Type, "fields", fieldsFetcher);
        Introspection.register(__Type, "interfaces", interfacesFetcher);
        Introspection.register(__Type, "possibleTypes", possibleTypesFetcher);
        Introspection.register(__Type, "enumValues", enumValuesTypesFetcher);
        Introspection.register(__Type, "inputFields", inputFieldsFetcher);
        Introspection.register(__Type, "ofType", OfTypeFetcher);
        Introspection.register(__Type, "name", nameDataFetcher);
        Introspection.register(__Type, "description", descriptionDataFetcher);
        Introspection.register(__Type, "specifiedByUrl", specifiedByUrlDataFetcher);
        __DirectiveLocation = GraphQLEnumType.newEnum().name("__DirectiveLocation").description("An enum describing valid locations where a directive can be placed").value("QUERY", (Object)DirectiveLocation.QUERY, "Indicates the directive is valid on queries.").value("MUTATION", (Object)DirectiveLocation.MUTATION, "Indicates the directive is valid on mutations.").value("FIELD", (Object)DirectiveLocation.FIELD, "Indicates the directive is valid on fields.").value("FRAGMENT_DEFINITION", (Object)DirectiveLocation.FRAGMENT_DEFINITION, "Indicates the directive is valid on fragment definitions.").value("FRAGMENT_SPREAD", (Object)DirectiveLocation.FRAGMENT_SPREAD, "Indicates the directive is valid on fragment spreads.").value("INLINE_FRAGMENT", (Object)DirectiveLocation.INLINE_FRAGMENT, "Indicates the directive is valid on inline fragments.").value("VARIABLE_DEFINITION", (Object)DirectiveLocation.INPUT_FIELD_DEFINITION, "Indicates the directive is valid on variable definitions.").value("SCHEMA", (Object)DirectiveLocation.SCHEMA, "Indicates the directive is valid on a schema SDL definition.").value("SCALAR", (Object)DirectiveLocation.SCALAR, "Indicates the directive is valid on a scalar SDL definition.").value("OBJECT", (Object)DirectiveLocation.OBJECT, "Indicates the directive is valid on an object SDL definition.").value("FIELD_DEFINITION", (Object)DirectiveLocation.FIELD_DEFINITION, "Indicates the directive is valid on a field SDL definition.").value("ARGUMENT_DEFINITION", (Object)DirectiveLocation.ARGUMENT_DEFINITION, "Indicates the directive is valid on a field argument SDL definition.").value("INTERFACE", (Object)DirectiveLocation.INTERFACE, "Indicates the directive is valid on an interface SDL definition.").value("UNION", (Object)DirectiveLocation.UNION, "Indicates the directive is valid on an union SDL definition.").value("ENUM", (Object)DirectiveLocation.ENUM, "Indicates the directive is valid on an enum SDL definition.").value("ENUM_VALUE", (Object)DirectiveLocation.ENUM_VALUE, "Indicates the directive is valid on an enum value SDL definition.").value("INPUT_OBJECT", (Object)DirectiveLocation.INPUT_OBJECT, "Indicates the directive is valid on an input object SDL definition.").value("INPUT_FIELD_DEFINITION", (Object)DirectiveLocation.INPUT_FIELD_DEFINITION, "Indicates the directive is valid on an input object field SDL definition.").build();
        __Directive = GraphQLObjectType.newObject().name("__Directive").field(GraphQLFieldDefinition.newFieldDefinition().name("name").description("The __Directive type represents a Directive that a server supports.").type(GraphQLNonNull.nonNull(Scalars.GraphQLString))).field(GraphQLFieldDefinition.newFieldDefinition().name("description").type(Scalars.GraphQLString)).field(GraphQLFieldDefinition.newFieldDefinition().name("isRepeatable").type(GraphQLNonNull.nonNull(Scalars.GraphQLBoolean))).field(GraphQLFieldDefinition.newFieldDefinition().name("locations").type(GraphQLNonNull.nonNull(GraphQLList.list(GraphQLNonNull.nonNull(__DirectiveLocation))))).field(GraphQLFieldDefinition.newFieldDefinition().name("args").type(GraphQLNonNull.nonNull(GraphQLList.list(GraphQLNonNull.nonNull(__InputValue))))).field(GraphQLFieldDefinition.newFieldDefinition().name("onOperation").type(Scalars.GraphQLBoolean).deprecate("Use `locations`.")).field(GraphQLFieldDefinition.newFieldDefinition().name("onFragment").type(Scalars.GraphQLBoolean).deprecate("Use `locations`.")).field(GraphQLFieldDefinition.newFieldDefinition().name("onField").type(Scalars.GraphQLBoolean).deprecate("Use `locations`.")).build();
        Introspection.register(__Directive, "locations", environment -> {
            GraphQLDirective directive = (GraphQLDirective)environment.getSource();
            return new ArrayList<DirectiveLocation>(directive.validLocations());
        });
        Introspection.register(__Directive, "args", environment -> {
            GraphQLDirective directive = (GraphQLDirective)environment.getSource();
            return directive.getArguments();
        });
        Introspection.register(__Directive, "name", nameDataFetcher);
        Introspection.register(__Directive, "description", descriptionDataFetcher);
        Introspection.register(__Directive, "isRepeatable", environment -> {
            GraphQLDirective directive = (GraphQLDirective)environment.getSource();
            return directive.isRepeatable();
        });
        __Schema = GraphQLObjectType.newObject().name("__Schema").description("A GraphQL Introspection defines the capabilities of a GraphQL server. It exposes all available types and directives on the server, the entry points for query, mutation, and subscription operations.").field(GraphQLFieldDefinition.newFieldDefinition().name("description").type(Scalars.GraphQLString)).field(GraphQLFieldDefinition.newFieldDefinition().name("types").description("A list of all types supported by this server.").type(GraphQLNonNull.nonNull(GraphQLList.list(GraphQLNonNull.nonNull(__Type))))).field(GraphQLFieldDefinition.newFieldDefinition().name("queryType").description("The type that query operations will be rooted at.").type(GraphQLNonNull.nonNull(__Type))).field(GraphQLFieldDefinition.newFieldDefinition().name("mutationType").description("If this server supports mutation, the type that mutation operations will be rooted at.").type(__Type)).field(GraphQLFieldDefinition.newFieldDefinition().name("directives").description("'A list of all directives supported by this server.").type(GraphQLNonNull.nonNull(GraphQLList.list(GraphQLNonNull.nonNull(__Directive))))).field(GraphQLFieldDefinition.newFieldDefinition().name("subscriptionType").description("'If this server support subscription, the type that subscription operations will be rooted at.").type(__Type)).build();
        Introspection.register(__Schema, "description", environment -> environment.getGraphQLSchema().getDescription());
        Introspection.register(__Schema, "types", environment -> {
            GraphQLSchema schema = (GraphQLSchema)environment.getSource();
            return schema.getAllTypesAsList();
        });
        Introspection.register(__Schema, "queryType", environment -> {
            GraphQLSchema schema = (GraphQLSchema)environment.getSource();
            return schema.getQueryType();
        });
        Introspection.register(__Schema, "mutationType", environment -> {
            GraphQLSchema schema = (GraphQLSchema)environment.getSource();
            return schema.getMutationType();
        });
        Introspection.register(__Schema, "directives", environment -> environment.getGraphQLSchema().getDirectives());
        Introspection.register(__Schema, "subscriptionType", environment -> {
            GraphQLSchema schema = (GraphQLSchema)environment.getSource();
            return schema.getSubscriptionType();
        });
        SchemaMetaFieldDefDataFetcher = IntrospectionDataFetchingEnvironment::getGraphQLSchema;
        SchemaMetaFieldDef = GraphQLFieldDefinition.newFieldDefinition().name("__schema").type(GraphQLNonNull.nonNull(__Schema)).description("Access the current type schema of this server.").build();
        TypeMetaFieldDefDataFetcher = environment -> {
            String name = (String)environment.getArgument("name");
            return environment.getGraphQLSchema().getType(name);
        };
        TypeMetaFieldDef = GraphQLFieldDefinition.newFieldDefinition().name("__type").type(__Type).description("Request the type information of a single type.").argument(GraphQLArgument.newArgument().name("name").type(GraphQLNonNull.nonNull(Scalars.GraphQLString))).build();
        TypeNameMetaFieldDefDataFetcher = environment -> GraphQLTypeUtil.simplePrint(environment.getParentType());
        TypeNameMetaFieldDef = GraphQLFieldDefinition.newFieldDefinition().name("__typename").type(GraphQLNonNull.nonNull(Scalars.GraphQLString)).description("The name of the current Object type at runtime.").build();
        IntrospectionQuery = GraphQLObjectType.newObject().name("IntrospectionQuery").field(SchemaMetaFieldDef).field(TypeMetaFieldDef).field(TypeNameMetaFieldDef).build();
        introspectionTypes.add(__DirectiveLocation);
        introspectionTypes.add(__TypeKind);
        introspectionTypes.add(__Type);
        introspectionTypes.add(__Schema);
        introspectionTypes.add(__InputValue);
        introspectionTypes.add(__Field);
        introspectionTypes.add(__EnumValue);
        introspectionTypes.add(__Directive);
        introspectionTypes.add(IntrospectionQuery);
        GraphQLSchema.newSchema().query(IntrospectionQuery).build();
    }

    public static enum DirectiveLocation {
        QUERY,
        MUTATION,
        SUBSCRIPTION,
        FIELD,
        FRAGMENT_DEFINITION,
        FRAGMENT_SPREAD,
        INLINE_FRAGMENT,
        VARIABLE_DEFINITION,
        SCHEMA,
        SCALAR,
        OBJECT,
        FIELD_DEFINITION,
        ARGUMENT_DEFINITION,
        INTERFACE,
        UNION,
        ENUM,
        ENUM_VALUE,
        INPUT_OBJECT,
        INPUT_FIELD_DEFINITION;

    }

    public static enum TypeKind {
        SCALAR,
        OBJECT,
        INTERFACE,
        UNION,
        ENUM,
        INPUT_OBJECT,
        LIST,
        NON_NULL;

    }
}

