/*
 * Decompiled with CFR 0.152.
 */
package graphql.language;

import graphql.Assert;
import graphql.AssertException;
import graphql.PublicApi;
import graphql.language.AbstractDescribedNode;
import graphql.language.Argument;
import graphql.language.ArrayValue;
import graphql.language.BooleanValue;
import graphql.language.Description;
import graphql.language.Directive;
import graphql.language.DirectiveDefinition;
import graphql.language.DirectiveLocation;
import graphql.language.Document;
import graphql.language.EnumTypeDefinition;
import graphql.language.EnumTypeExtensionDefinition;
import graphql.language.EnumValue;
import graphql.language.EnumValueDefinition;
import graphql.language.Field;
import graphql.language.FieldDefinition;
import graphql.language.FloatValue;
import graphql.language.FragmentDefinition;
import graphql.language.FragmentSpread;
import graphql.language.InlineFragment;
import graphql.language.InputObjectTypeDefinition;
import graphql.language.InputObjectTypeExtensionDefinition;
import graphql.language.InputValueDefinition;
import graphql.language.IntValue;
import graphql.language.InterfaceTypeDefinition;
import graphql.language.InterfaceTypeExtensionDefinition;
import graphql.language.ListType;
import graphql.language.Node;
import graphql.language.NonNullType;
import graphql.language.NullValue;
import graphql.language.ObjectField;
import graphql.language.ObjectTypeDefinition;
import graphql.language.ObjectTypeExtensionDefinition;
import graphql.language.ObjectValue;
import graphql.language.OperationDefinition;
import graphql.language.OperationTypeDefinition;
import graphql.language.ScalarTypeDefinition;
import graphql.language.ScalarTypeExtensionDefinition;
import graphql.language.SchemaDefinition;
import graphql.language.SchemaExtensionDefinition;
import graphql.language.SelectionSet;
import graphql.language.StringValue;
import graphql.language.Type;
import graphql.language.TypeName;
import graphql.language.UnionTypeDefinition;
import graphql.language.UnionTypeExtensionDefinition;
import graphql.language.Value;
import graphql.language.VariableDefinition;
import graphql.language.VariableReference;
import graphql.util.EscapeUtil;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@PublicApi
public class AstPrinter {
    private final Map<Class<? extends Node>, NodePrinter<? extends Node>> printers = new LinkedHashMap<Class<? extends Node>, NodePrinter<? extends Node>>();
    private final boolean compactMode;

    private AstPrinter(boolean compactMode) {
        this.compactMode = compactMode;
        this.printers.put(Argument.class, this.argument());
        this.printers.put(ArrayValue.class, this.value());
        this.printers.put(BooleanValue.class, this.value());
        this.printers.put(NullValue.class, this.value());
        this.printers.put(Directive.class, this.directive());
        this.printers.put(DirectiveDefinition.class, this.directiveDefinition());
        this.printers.put(DirectiveLocation.class, this.directiveLocation());
        this.printers.put(Document.class, this.document());
        this.printers.put(EnumTypeDefinition.class, this.enumTypeDefinition());
        this.printers.put(EnumTypeExtensionDefinition.class, this.enumTypeExtensionDefinition());
        this.printers.put(EnumValue.class, this.enumValue());
        this.printers.put(EnumValueDefinition.class, this.enumValueDefinition());
        this.printers.put(Field.class, this.field());
        this.printers.put(FieldDefinition.class, this.fieldDefinition());
        this.printers.put(FloatValue.class, this.value());
        this.printers.put(FragmentDefinition.class, this.fragmentDefinition());
        this.printers.put(FragmentSpread.class, this.fragmentSpread());
        this.printers.put(InlineFragment.class, this.inlineFragment());
        this.printers.put(InputObjectTypeDefinition.class, this.inputObjectTypeDefinition());
        this.printers.put(InputObjectTypeExtensionDefinition.class, this.inputObjectTypeExtensionDefinition());
        this.printers.put(InputValueDefinition.class, this.inputValueDefinition());
        this.printers.put(InterfaceTypeDefinition.class, this.interfaceTypeDefinition());
        this.printers.put(InterfaceTypeExtensionDefinition.class, this.interfaceTypeExtensionDefinition());
        this.printers.put(IntValue.class, this.value());
        this.printers.put(ListType.class, this.type());
        this.printers.put(NonNullType.class, this.type());
        this.printers.put(ObjectField.class, this.objectField());
        this.printers.put(ObjectTypeDefinition.class, this.objectTypeDefinition());
        this.printers.put(ObjectTypeExtensionDefinition.class, this.objectTypeExtensionDefinition());
        this.printers.put(ObjectValue.class, this.value());
        this.printers.put(OperationDefinition.class, this.operationDefinition());
        this.printers.put(OperationTypeDefinition.class, this.operationTypeDefinition());
        this.printers.put(ScalarTypeDefinition.class, this.scalarTypeDefinition());
        this.printers.put(ScalarTypeExtensionDefinition.class, this.scalarTypeExtensionDefinition());
        this.printers.put(SchemaDefinition.class, this.schemaDefinition());
        this.printers.put(SchemaExtensionDefinition.class, this.schemaExtensionDefinition());
        this.printers.put(SelectionSet.class, this.selectionSet());
        this.printers.put(StringValue.class, this.value());
        this.printers.put(TypeName.class, this.type());
        this.printers.put(UnionTypeDefinition.class, this.unionTypeDefinition());
        this.printers.put(UnionTypeExtensionDefinition.class, this.unionTypeExtensionDefinition());
        this.printers.put(VariableDefinition.class, this.variableDefinition());
        this.printers.put(VariableReference.class, this.variableReference());
    }

    private NodePrinter<Argument> argument() {
        if (this.compactMode) {
            return (out, node) -> out.printf("%s:%s", node.getName(), this.value(node.getValue()));
        }
        return (out, node) -> out.printf("%s: %s", node.getName(), this.value(node.getValue()));
    }

    private NodePrinter<Document> document() {
        if (this.compactMode) {
            return (out, node) -> out.printf("%s", this.join(node.getDefinitions(), " "));
        }
        return (out, node) -> out.printf("%s\n", this.join(node.getDefinitions(), "\n\n"));
    }

    private NodePrinter<Directive> directive() {
        String argSep = this.compactMode ? "," : ", ";
        return (out, node) -> {
            String arguments = this.wrap("(", this.join(node.getArguments(), argSep), ")");
            out.printf("@%s%s", node.getName(), arguments);
        };
    }

    private NodePrinter<DirectiveDefinition> directiveDefinition() {
        String argSep = this.compactMode ? "," : ", ";
        return (out, node) -> {
            out.printf("%s", this.description(node));
            String arguments = this.wrap("(", this.join(node.getInputValueDefinitions(), argSep), ")");
            String locations = this.join(node.getDirectiveLocations(), " | ");
            String repeatable = node.isRepeatable() ? "repeatable " : "";
            out.printf("directive @%s%s %son %s", node.getName(), arguments, repeatable, locations);
        };
    }

    private NodePrinter<DirectiveLocation> directiveLocation() {
        return (out, node) -> out.print(node.getName());
    }

    private NodePrinter<EnumTypeDefinition> enumTypeDefinition() {
        return (out, node) -> {
            out.printf("%s", this.description(node));
            out.printf("%s", this.spaced("enum", node.getName(), this.directives(node.getDirectives()), this.block(node.getEnumValueDefinitions())));
        };
    }

    private NodePrinter<EnumValue> enumValue() {
        return (out, node) -> out.printf("%s", node.getName());
    }

    private NodePrinter<EnumValueDefinition> enumValueDefinition() {
        return (out, node) -> {
            out.printf("%s", this.description(node));
            out.printf("%s", this.spaced(node.getName(), this.directives(node.getDirectives())));
        };
    }

    private NodePrinter<Field> field() {
        String argSep = this.compactMode ? "," : ", ";
        String aliasSuffix = this.compactMode ? ":" : ": ";
        return (out, node) -> {
            String alias = this.wrap("", node.getAlias(), aliasSuffix);
            String name = node.getName();
            String arguments = this.wrap("(", this.join(node.getArguments(), argSep), ")");
            String directives = this.directives(node.getDirectives());
            String selectionSet = this.node(node.getSelectionSet());
            out.printf("%s", this.spaced(alias + name + arguments, directives, selectionSet));
        };
    }

    private NodePrinter<FieldDefinition> fieldDefinition() {
        String argSep = this.compactMode ? "," : ", ";
        return (out, node) -> {
            if (this.hasDescription(node.getInputValueDefinitions()) && !this.compactMode) {
                out.printf("%s", this.description(node));
                String args = this.join(node.getInputValueDefinitions(), "\n");
                out.printf("%s", node.getName() + this.wrap("(\n", args, ")") + ": " + this.spaced(this.type(node.getType()), this.directives(node.getDirectives())));
            } else {
                String args = this.join(node.getInputValueDefinitions(), argSep);
                out.printf("%s", node.getName() + this.wrap("(", args, ")") + ": " + this.spaced(this.type(node.getType()), this.directives(node.getDirectives())));
            }
        };
    }

    private boolean hasDescription(List<? extends Node> nodes) {
        return nodes.stream().filter(it -> it instanceof AbstractDescribedNode).anyMatch(it -> ((AbstractDescribedNode)it).getDescription() != null);
    }

    private NodePrinter<FragmentDefinition> fragmentDefinition() {
        return (out, node) -> {
            String name = node.getName();
            String typeCondition = this.type(node.getTypeCondition());
            String directives = this.directives(node.getDirectives());
            String selectionSet = this.node(node.getSelectionSet());
            out.printf("fragment %s on %s ", name, typeCondition);
            out.printf("%s", directives + selectionSet);
        };
    }

    private NodePrinter<FragmentSpread> fragmentSpread() {
        return (out, node) -> {
            String name = node.getName();
            String directives = this.directives(node.getDirectives());
            out.printf("...%s%s", name, directives);
        };
    }

    private NodePrinter<InlineFragment> inlineFragment() {
        return (out, node) -> {
            TypeName typeName = node.getTypeCondition();
            String typeCondition = typeName == null ? "" : this.wrap("on ", this.type(typeName), "");
            String directives = this.directives(node.getDirectives());
            String selectionSet = this.node(node.getSelectionSet());
            out.printf("%s", this.spaced("...", typeCondition, directives, selectionSet));
        };
    }

    private NodePrinter<InputObjectTypeDefinition> inputObjectTypeDefinition() {
        return (out, node) -> {
            out.printf("%s", this.description(node));
            out.printf("%s", this.spaced("input", node.getName(), this.directives(node.getDirectives()), this.block(node.getInputValueDefinitions())));
        };
    }

    private NodePrinter<InputValueDefinition> inputValueDefinition() {
        String nameTypeSep = this.compactMode ? ":" : ": ";
        String defaultValueEquals = this.compactMode ? "=" : "= ";
        return (out, node) -> {
            Value defaultValue = node.getDefaultValue();
            out.printf("%s", this.description(node));
            out.printf("%s", this.spaced(node.getName() + nameTypeSep + this.type(node.getType()), this.wrap(defaultValueEquals, defaultValue, ""), this.directives(node.getDirectives())));
        };
    }

    private NodePrinter<InterfaceTypeDefinition> interfaceTypeDefinition() {
        return (out, node) -> {
            out.printf("%s", this.description(node));
            out.printf("%s", this.spaced("interface", node.getName(), this.wrap("implements ", this.join(node.getImplements(), " & "), ""), this.directives(node.getDirectives()), this.block(node.getFieldDefinitions())));
        };
    }

    private NodePrinter<ObjectField> objectField() {
        String nameValueSep = this.compactMode ? ":" : " : ";
        return (out, node) -> out.printf("%s%s%s", node.getName(), nameValueSep, this.value(node.getValue()));
    }

    private NodePrinter<OperationDefinition> operationDefinition() {
        String argSep = this.compactMode ? "," : ", ";
        return (out, node) -> {
            String op = node.getOperation().toString().toLowerCase();
            String name = node.getName();
            String varDefinitions = this.wrap("(", this.join(this.nvl(node.getVariableDefinitions()), argSep), ")");
            String directives = this.directives(node.getDirectives());
            String selectionSet = this.node(node.getSelectionSet());
            if (this.isEmpty(name) && this.isEmpty(directives) && this.isEmpty(varDefinitions) && op.equals("QUERY")) {
                out.printf("%s", selectionSet);
            } else {
                out.printf("%s", this.spaced(op, this.smooshed(name, varDefinitions), directives, selectionSet));
            }
        };
    }

    private NodePrinter<OperationTypeDefinition> operationTypeDefinition() {
        String nameTypeSep = this.compactMode ? ":" : ": ";
        return (out, node) -> out.printf("%s%s%s", node.getName(), nameTypeSep, this.type(node.getTypeName()));
    }

    private NodePrinter<ObjectTypeDefinition> objectTypeDefinition() {
        return (out, node) -> {
            out.printf("%s", this.description(node));
            out.printf("%s", this.spaced("type", node.getName(), this.wrap("implements ", this.join(node.getImplements(), " & "), ""), this.directives(node.getDirectives()), this.block(node.getFieldDefinitions())));
        };
    }

    private NodePrinter<SelectionSet> selectionSet() {
        return (out, node) -> out.printf("%s", this.block(node.getSelections()));
    }

    private NodePrinter<ScalarTypeDefinition> scalarTypeDefinition() {
        return (out, node) -> {
            out.printf("%s", this.description(node));
            out.printf("%s", this.spaced("scalar", node.getName(), this.directives(node.getDirectives())));
        };
    }

    private NodePrinter<SchemaDefinition> schemaDefinition() {
        return (out, node) -> {
            out.printf("%s", this.description(node));
            out.printf("%s", this.spaced("schema", this.directives(node.getDirectives()), this.block(node.getOperationTypeDefinitions())));
        };
    }

    private NodePrinter<Type> type() {
        return (out, node) -> out.print(this.type((Type)node));
    }

    private String type(Type type) {
        if (type instanceof NonNullType) {
            NonNullType inner = (NonNullType)type;
            return this.wrap("", this.type(inner.getType()), "!");
        }
        if (type instanceof ListType) {
            ListType inner = (ListType)type;
            return this.wrap("[", this.type(inner.getType()), "]");
        }
        TypeName inner = (TypeName)type;
        return inner.getName();
    }

    private NodePrinter<ObjectTypeExtensionDefinition> objectTypeExtensionDefinition() {
        return (out, node) -> out.printf("extend %s", this.node(node, ObjectTypeDefinition.class));
    }

    private NodePrinter<EnumTypeExtensionDefinition> enumTypeExtensionDefinition() {
        return (out, node) -> out.printf("extend %s", this.node(node, EnumTypeDefinition.class));
    }

    private NodePrinter<InterfaceTypeDefinition> interfaceTypeExtensionDefinition() {
        return (out, node) -> out.printf("extend %s", this.node(node, InterfaceTypeDefinition.class));
    }

    private NodePrinter<UnionTypeExtensionDefinition> unionTypeExtensionDefinition() {
        return (out, node) -> out.printf("extend %s", this.node(node, UnionTypeDefinition.class));
    }

    private NodePrinter<ScalarTypeExtensionDefinition> scalarTypeExtensionDefinition() {
        return (out, node) -> out.printf("extend %s", this.node(node, ScalarTypeDefinition.class));
    }

    private NodePrinter<InputObjectTypeExtensionDefinition> inputObjectTypeExtensionDefinition() {
        return (out, node) -> out.printf("extend %s", this.node(node, InputObjectTypeDefinition.class));
    }

    private NodePrinter<SchemaExtensionDefinition> schemaExtensionDefinition() {
        return (out, node) -> out.printf("extend %s", this.node(node, SchemaDefinition.class));
    }

    private NodePrinter<UnionTypeDefinition> unionTypeDefinition() {
        String barSep = this.compactMode ? "|" : " | ";
        String equals = this.compactMode ? "=" : "= ";
        return (out, node) -> {
            out.printf("%s", this.description(node));
            out.printf("%s", this.spaced("union", node.getName(), this.directives(node.getDirectives()), equals + this.join(node.getMemberTypes(), barSep)));
        };
    }

    private NodePrinter<VariableDefinition> variableDefinition() {
        String nameTypeSep = this.compactMode ? ":" : ": ";
        String defaultValueEquals = this.compactMode ? "=" : " = ";
        return (out, node) -> out.printf("$%s%s%s%s%s", node.getName(), nameTypeSep, this.type(node.getType()), this.wrap(defaultValueEquals, node.getDefaultValue(), ""), this.directives(node.getDirectives()));
    }

    private NodePrinter<VariableReference> variableReference() {
        return (out, node) -> out.printf("$%s", node.getName());
    }

    private String node(Node node) {
        return this.node(node, null);
    }

    private String node(Node node, Class startClass) {
        if (startClass != null) {
            Assert.assertTrue(startClass.isInstance(node), () -> "The starting class must be in the inherit tree");
        }
        StringWriter sw = new StringWriter();
        PrintWriter out = new PrintWriter(sw);
        NodePrinter<Node> printer = this._findPrinter(node, startClass);
        printer.print(out, node);
        return sw.toString();
    }

    private <T extends Node> NodePrinter<T> _findPrinter(Node node) {
        return this._findPrinter(node, null);
    }

    private <T extends Node> NodePrinter<T> _findPrinter(Node node, Class startClass) {
        Class<?> clazz;
        if (node == null) {
            return (out, type) -> {};
        }
        Class<?> clazz2 = clazz = startClass != null ? startClass : node.getClass();
        while (clazz != Object.class) {
            NodePrinter<? extends Node> nodePrinter = this.printers.get(clazz);
            if (nodePrinter != null) {
                return nodePrinter;
            }
            clazz = clazz.getSuperclass();
        }
        throw new AssertException(String.format("We have a missing printer implementation for %s : report a bug!", clazz));
    }

    private <T> boolean isEmpty(List<T> list) {
        return list == null || list.isEmpty();
    }

    private boolean isEmpty(String s2) {
        return s2 == null || s2.trim().length() == 0;
    }

    private <T> List<T> nvl(List<T> list) {
        return list != null ? list : Collections.emptyList();
    }

    private NodePrinter<Value> value() {
        return (out, node) -> out.print(this.value((Value)node));
    }

    private String value(Value value) {
        String argSep;
        String string = argSep = this.compactMode ? "," : ", ";
        if (value instanceof IntValue) {
            return String.valueOf(((IntValue)value).getValue());
        }
        if (value instanceof FloatValue) {
            return String.valueOf(((FloatValue)value).getValue());
        }
        if (value instanceof StringValue) {
            return this.wrap("\"", EscapeUtil.escapeJsonString(((StringValue)value).getValue()), "\"");
        }
        if (value instanceof EnumValue) {
            return String.valueOf(((EnumValue)value).getName());
        }
        if (value instanceof BooleanValue) {
            return String.valueOf(((BooleanValue)value).isValue());
        }
        if (value instanceof NullValue) {
            return "null";
        }
        if (value instanceof ArrayValue) {
            return "[" + this.join(((ArrayValue)value).getValues(), argSep) + "]";
        }
        if (value instanceof ObjectValue) {
            return "{" + this.join(((ObjectValue)value).getObjectFields(), argSep) + "}";
        }
        if (value instanceof VariableReference) {
            return "$" + ((VariableReference)value).getName();
        }
        return "";
    }

    private String description(Node<?> node) {
        boolean startNewLine;
        Description description = ((AbstractDescribedNode)node).getDescription();
        if (description == null || description.getContent() == null || this.compactMode) {
            return "";
        }
        boolean bl = startNewLine = description.getContent().charAt(0) == '\n';
        String s2 = description.isMultiLine() ? "\"\"\"" + (startNewLine ? "" : "\n") + description.getContent() + "\n\"\"\"\n" : "\"" + description.getContent() + "\"\n";
        return s2;
    }

    private String directives(List<Directive> directives) {
        return this.join(this.nvl(directives), " ");
    }

    private <T extends Node> String join(List<T> nodes, String delim) {
        return this.join(nodes, delim, "", "");
    }

    private <T extends Node> String join(List<T> nodes, String delim, String prefix, String suffix) {
        String s2 = this.nvl(nodes).stream().map(this::node).collect(Collectors.joining(delim, prefix, suffix));
        return s2;
    }

    private String spaced(String ... args) {
        return this.join(" ", args);
    }

    private String smooshed(String ... args) {
        return this.join("", args);
    }

    private String join(String delim, String ... args) {
        String s2 = Arrays.stream(args).filter(arg -> !this.isEmpty((String)arg)).collect(Collectors.joining(delim));
        return s2;
    }

    String wrap(String start, String maybeString, String end) {
        if (this.isEmpty(maybeString)) {
            if (start.equals("\"") && end.equals("\"")) {
                return "\"\"";
            }
            return "";
        }
        return start + maybeString + (!this.isEmpty(end) ? end : "");
    }

    private <T extends Node> String block(List<T> nodes) {
        if (this.isEmpty(nodes)) {
            return "{}";
        }
        if (this.compactMode) {
            return "{" + this.join(nodes, " ") + "}";
        }
        return this.indent("{\n" + this.join(nodes, "\n")) + "\n}";
    }

    private String indent(String maybeString) {
        if (this.isEmpty(maybeString)) {
            return "";
        }
        maybeString = maybeString.replaceAll("\\n", "\n  ");
        return maybeString;
    }

    String wrap(String start, Node maybeNode, String end) {
        if (maybeNode == null) {
            return "";
        }
        return start + this.node(maybeNode) + (this.isEmpty(end) ? "" : end);
    }

    public static String printAst(Node node) {
        StringWriter sw = new StringWriter();
        AstPrinter.printAst(sw, node);
        return sw.toString();
    }

    public static void printAst(Writer writer, Node node) {
        AstPrinter.printImpl(writer, node, false);
    }

    public static String printAstCompact(Node node) {
        StringWriter sw = new StringWriter();
        AstPrinter.printImpl(sw, node, true);
        return sw.toString();
    }

    private static void printImpl(Writer writer, Node node, boolean compactMode) {
        AstPrinter astPrinter = new AstPrinter(compactMode);
        NodePrinter<Node> printer = astPrinter._findPrinter(node);
        printer.print(new PrintWriter(writer), node);
    }

    private static interface NodePrinter<T extends Node> {
        public void print(PrintWriter var1, T var2);
    }
}

