/*
 * Decompiled with CFR 0.152.
 */
package graphql.language;

import graphql.PublicApi;
import graphql.com.google.common.collect.ImmutableList;
import graphql.language.ArrayValue;
import graphql.language.AstSorter;
import graphql.language.AstTransformer;
import graphql.language.BooleanValue;
import graphql.language.Document;
import graphql.language.Field;
import graphql.language.FloatValue;
import graphql.language.FragmentDefinition;
import graphql.language.IntValue;
import graphql.language.Node;
import graphql.language.NodeVisitorStub;
import graphql.language.ObjectValue;
import graphql.language.OperationDefinition;
import graphql.language.StringValue;
import graphql.language.VariableDefinition;
import graphql.language.VariableReference;
import graphql.util.TraversalControl;
import graphql.util.TraverserContext;
import graphql.util.TreeTransformerUtil;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

@PublicApi
public class AstSignature {
    public Document signatureQuery(Document document, String operationName) {
        return this.sortAST(this.removeAliases(this.hideLiterals(this.dropUnusedQueryDefinitions(document, operationName))));
    }

    private Document hideLiterals(Document document) {
        final HashMap variableRemapping = new HashMap();
        final AtomicInteger variableCount = new AtomicInteger();
        NodeVisitorStub visitor = new NodeVisitorStub(){

            @Override
            public TraversalControl visitIntValue(IntValue node, TraverserContext<Node> context) {
                return TreeTransformerUtil.changeNode(context, node.transform(builder -> builder.value(BigInteger.ZERO)));
            }

            @Override
            public TraversalControl visitFloatValue(FloatValue node, TraverserContext<Node> context) {
                return TreeTransformerUtil.changeNode(context, node.transform(builder -> builder.value(BigDecimal.ZERO)));
            }

            @Override
            public TraversalControl visitStringValue(StringValue node, TraverserContext<Node> context) {
                return TreeTransformerUtil.changeNode(context, node.transform(builder -> builder.value("")));
            }

            @Override
            public TraversalControl visitBooleanValue(BooleanValue node, TraverserContext<Node> context) {
                return TreeTransformerUtil.changeNode(context, node.transform(builder -> builder.value(false)));
            }

            @Override
            public TraversalControl visitArrayValue(ArrayValue node, TraverserContext<Node> context) {
                return TreeTransformerUtil.changeNode(context, node.transform(builder -> builder.values(Collections.emptyList())));
            }

            @Override
            public TraversalControl visitObjectValue(ObjectValue node, TraverserContext<Node> context) {
                return TreeTransformerUtil.changeNode(context, node.transform(builder -> builder.objectFields(Collections.emptyList())));
            }

            @Override
            public TraversalControl visitVariableReference(VariableReference node, TraverserContext<Node> context) {
                String varName = AstSignature.this.remapVariable(node.getName(), variableRemapping, variableCount);
                return TreeTransformerUtil.changeNode(context, node.transform(builder -> builder.name(varName)));
            }

            @Override
            public TraversalControl visitVariableDefinition(VariableDefinition node, TraverserContext<Node> context) {
                String varName = AstSignature.this.remapVariable(node.getName(), variableRemapping, variableCount);
                return TreeTransformerUtil.changeNode(context, node.transform(builder -> builder.name(varName)));
            }
        };
        return this.transformDoc(document, visitor);
    }

    private String remapVariable(String varName, Map<String, String> variableRemapping, AtomicInteger variableCount) {
        String mappedName = variableRemapping.get(varName);
        if (mappedName == null) {
            mappedName = "var" + variableCount.incrementAndGet();
            variableRemapping.put(varName, mappedName);
        }
        return mappedName;
    }

    private Document removeAliases(Document document) {
        NodeVisitorStub visitor = new NodeVisitorStub(){

            @Override
            public TraversalControl visitField(Field node, TraverserContext<Node> context) {
                return TreeTransformerUtil.changeNode(context, node.transform(builder -> builder.alias(null)));
            }
        };
        return this.transformDoc(document, visitor);
    }

    private Document sortAST(Document document) {
        return new AstSorter().sort(document);
    }

    private Document dropUnusedQueryDefinitions(Document document, final String operationName) {
        NodeVisitorStub visitor = new NodeVisitorStub(){

            @Override
            public TraversalControl visitDocument(Document node, TraverserContext<Node> context) {
                List wantedDefinitions = node.getDefinitions().stream().filter(d -> {
                    if (d instanceof OperationDefinition) {
                        OperationDefinition operationDefinition = (OperationDefinition)d;
                        return AstSignature.this.isThisOperation(operationDefinition, operationName);
                    }
                    return d instanceof FragmentDefinition;
                }).collect(ImmutableList.toImmutableList());
                Document changedNode = node.transform(builder -> builder.definitions(wantedDefinitions));
                return TreeTransformerUtil.changeNode(context, changedNode);
            }
        };
        return this.transformDoc(document, visitor);
    }

    private boolean isThisOperation(OperationDefinition operationDefinition, String operationName) {
        String name = operationDefinition.getName();
        if (operationName == null) {
            return name == null;
        }
        return operationName.equals(name);
    }

    private Document transformDoc(Document document, NodeVisitorStub visitor) {
        AstTransformer astTransformer = new AstTransformer();
        Node newDoc = astTransformer.transform(document, visitor);
        return (Document)newDoc;
    }
}

