/*
 * Decompiled with CFR 0.152.
 */
package graphql.language;

import graphql.Assert;
import graphql.AssertException;
import graphql.Internal;
import graphql.Scalars;
import graphql.language.ArrayValue;
import graphql.language.BooleanValue;
import graphql.language.Document;
import graphql.language.EnumValue;
import graphql.language.FloatValue;
import graphql.language.InputObjectTypeDefinition;
import graphql.language.InputValueDefinition;
import graphql.language.IntValue;
import graphql.language.ObjectField;
import graphql.language.ObjectValue;
import graphql.language.StringValue;
import graphql.language.Value;
import graphql.parser.Parser;
import graphql.schema.GraphQLEnumType;
import graphql.schema.GraphQLInputObjectField;
import graphql.schema.GraphQLInputObjectType;
import graphql.schema.GraphQLInputType;
import graphql.schema.GraphQLList;
import graphql.schema.GraphQLNonNull;
import graphql.schema.GraphQLScalarType;
import graphql.schema.GraphQLType;
import graphql.schema.GraphQLTypeUtil;
import graphql.schema.PropertyDataFetcherHelper;
import graphql.util.FpKit;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

@Internal
public class AstValueHelper {
    public static Value<?> astFromValue(Object value, GraphQLType type) {
        if (value == null) {
            return null;
        }
        if (GraphQLTypeUtil.isNonNull(type)) {
            return AstValueHelper.handleNonNull(value, (GraphQLNonNull)type);
        }
        if (GraphQLTypeUtil.isList(type)) {
            return AstValueHelper.handleList(value, (GraphQLList)type);
        }
        if (type instanceof GraphQLInputObjectType) {
            return AstValueHelper.handleInputObject(value, (GraphQLInputObjectType)type);
        }
        if (!(type instanceof GraphQLScalarType) && !(type instanceof GraphQLEnumType)) {
            throw new AssertException("Must provide Input Type, cannot use: " + type.getClass());
        }
        Object serialized = AstValueHelper.serialize(type, value);
        if (AstValueHelper.isNullish(serialized)) {
            return null;
        }
        if (serialized instanceof Boolean) {
            return BooleanValue.newBooleanValue().value((Boolean)serialized).build();
        }
        String stringValue = serialized.toString();
        if (serialized instanceof Number) {
            return AstValueHelper.handleNumber(stringValue);
        }
        if (serialized instanceof String) {
            if (type instanceof GraphQLEnumType) {
                return EnumValue.newEnumValue().name(stringValue).build();
            }
            if (type == Scalars.GraphQLID && stringValue.matches("^[0-9]+$")) {
                return IntValue.newIntValue().value(new BigInteger(stringValue)).build();
            }
            return StringValue.newStringValue().value(stringValue).build();
        }
        throw new AssertException("'Cannot convert value to AST: " + serialized);
    }

    private static Value<?> handleInputObject(Object javaValue, GraphQLInputObjectType type) {
        List<GraphQLInputObjectField> fields = type.getFields();
        ArrayList<ObjectField> fieldNodes = new ArrayList<ObjectField>();
        fields.forEach(field -> {
            GraphQLInputType fieldType;
            String fieldName = field.getName();
            Object fieldValueObj = PropertyDataFetcherHelper.getPropertyValue(fieldName, javaValue, fieldType = field.getType());
            Value<?> nodeValue = AstValueHelper.astFromValue(fieldValueObj, fieldType);
            if (nodeValue != null) {
                fieldNodes.add(ObjectField.newObjectField().name(fieldName).value(nodeValue).build());
            }
        });
        return ObjectValue.newObjectValue().objectFields(fieldNodes).build();
    }

    private static Value<?> handleNumber(String stringValue) {
        if (stringValue.matches("^[0-9]+$")) {
            return IntValue.newIntValue().value(new BigInteger(stringValue)).build();
        }
        return FloatValue.newFloatValue().value(new BigDecimal(stringValue)).build();
    }

    private static Value<?> handleList(Object _value, GraphQLList type) {
        GraphQLType itemType = type.getWrappedType();
        boolean isIterable = _value instanceof Iterable;
        if (isIterable || _value != null && _value.getClass().isArray()) {
            Collection iterable = isIterable ? (Collection)_value : FpKit.toCollection(_value);
            ArrayList<Value> valuesNodes = new ArrayList<Value>();
            for (Object item : iterable) {
                Value<?> itemNode = AstValueHelper.astFromValue(item, itemType);
                if (itemNode == null) continue;
                valuesNodes.add(itemNode);
            }
            return ArrayValue.newArrayValue().values(valuesNodes).build();
        }
        return AstValueHelper.astFromValue(_value, itemType);
    }

    private static Value<?> handleNonNull(Object _value, GraphQLNonNull type) {
        GraphQLType wrappedType = type.getWrappedType();
        return AstValueHelper.astFromValue(_value, wrappedType);
    }

    private static Object serialize(GraphQLType type, Object value) {
        if (type instanceof GraphQLScalarType) {
            return ((GraphQLScalarType)type).getCoercing().serialize(value);
        }
        return ((GraphQLEnumType)type).serialize(value);
    }

    private static boolean isNullish(Object serialized) {
        if (serialized instanceof Number) {
            return Double.isNaN(((Number)serialized).doubleValue());
        }
        return serialized == null;
    }

    public static Value<?> valueFromAst(String astLiteral) {
        String toParse = "input X { x : String = " + astLiteral + "}";
        try {
            Document doc = new Parser().parseDocument(toParse);
            InputObjectTypeDefinition inputType = (InputObjectTypeDefinition)doc.getDefinitions().get(0);
            InputValueDefinition inputValueDefinition = inputType.getInputValueDefinitions().get(0);
            return inputValueDefinition.getDefaultValue();
        }
        catch (Exception e) {
            return (Value)Assert.assertShouldNeverHappen("valueFromAst of '%s' failed because of '%s'", astLiteral, e.getMessage());
        }
    }
}

