/*
 * Decompiled with CFR 0.152.
 */
package graphql.language;

import graphql.Internal;
import graphql.com.google.common.collect.ImmutableList;
import graphql.execution.UnknownOperationException;
import graphql.language.Argument;
import graphql.language.Definition;
import graphql.language.Directive;
import graphql.language.Document;
import graphql.language.FragmentDefinition;
import graphql.language.Node;
import graphql.language.NodeChildrenContainer;
import graphql.language.OperationDefinition;
import graphql.util.FpKit;
import graphql.util.NodeLocation;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

@Internal
public class NodeUtil {
    public static boolean isEqualTo(String thisStr, String thatStr) {
        return !(null == thisStr ? null != thatStr : !thisStr.equals(thatStr));
    }

    public static Map<String, ImmutableList<Directive>> allDirectivesByName(List<Directive> directives) {
        return FpKit.groupingBy(directives, Directive::getName);
    }

    public static Map<String, Argument> argumentsByName(List<Argument> arguments) {
        return FpKit.getByName(arguments, Argument::getName, FpKit.mergeFirst());
    }

    public static Argument getArgumentByName(List<Argument> arguments, String name) {
        for (Argument argument : arguments) {
            if (!argument.getName().equals(name)) continue;
            return argument;
        }
        return null;
    }

    public static Map<String, FragmentDefinition> getFragmentsByName(Document document) {
        LinkedHashMap<String, FragmentDefinition> fragmentsByName = new LinkedHashMap<String, FragmentDefinition>();
        for (Definition definition : document.getDefinitions()) {
            if (!(definition instanceof FragmentDefinition)) continue;
            FragmentDefinition fragmentDefinition = (FragmentDefinition)definition;
            fragmentsByName.put(fragmentDefinition.getName(), fragmentDefinition);
        }
        return fragmentsByName;
    }

    public static GetOperationResult getOperation(Document document, String operationName) {
        LinkedHashMap<String, FragmentDefinition> fragmentsByName = new LinkedHashMap<String, FragmentDefinition>();
        LinkedHashMap<String, OperationDefinition> operationsByName = new LinkedHashMap<String, OperationDefinition>();
        for (Definition definition : document.getDefinitions()) {
            if (definition instanceof OperationDefinition) {
                OperationDefinition operationDefinition = (OperationDefinition)definition;
                operationsByName.put(operationDefinition.getName(), operationDefinition);
            }
            if (!(definition instanceof FragmentDefinition)) continue;
            FragmentDefinition fragmentDefinition = (FragmentDefinition)definition;
            fragmentsByName.put(fragmentDefinition.getName(), fragmentDefinition);
        }
        if (operationName == null && operationsByName.size() > 1) {
            throw new UnknownOperationException("Must provide operation name if query contains multiple operations.");
        }
        OperationDefinition operation = operationName == null || operationName.isEmpty() ? (OperationDefinition)operationsByName.values().iterator().next() : (OperationDefinition)operationsByName.get(operationName);
        if (operation == null) {
            throw new UnknownOperationException(String.format("Unknown operation named '%s'.", operationName));
        }
        GetOperationResult result = new GetOperationResult();
        result.fragmentsByName = fragmentsByName;
        result.operationDefinition = operation;
        return result;
    }

    public static void assertNewChildrenAreEmpty(NodeChildrenContainer newChildren) {
        if (!newChildren.isEmpty()) {
            throw new IllegalArgumentException("Cannot pass non-empty newChildren to Node that doesn't hold children");
        }
    }

    public static Node removeChild(Node node, NodeLocation childLocationToRemove) {
        NodeChildrenContainer namedChildren = node.getNamedChildren();
        NodeChildrenContainer newChildren = namedChildren.transform(builder -> builder.removeChild(childLocationToRemove.getName(), childLocationToRemove.getIndex()));
        return node.withNewChildren(newChildren);
    }

    public static class GetOperationResult {
        public OperationDefinition operationDefinition;
        public Map<String, FragmentDefinition> fragmentsByName;
    }
}

