/*
 * Decompiled with CFR 0.152.
 */
package graphql.normalized;

import graphql.Assert;
import graphql.Internal;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLTypeUtil;
import graphql.schema.GraphQLUnmodifiedType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;

@Internal
public class NormalizedField {
    private final String alias;
    private final Map<String, Object> arguments;
    private final GraphQLObjectType objectType;
    private final GraphQLFieldDefinition fieldDefinition;
    private final List<NormalizedField> children;
    private final boolean isConditional;
    private final int level;
    private NormalizedField parent;

    private NormalizedField(Builder builder) {
        GraphQLUnmodifiedType parentType;
        this.alias = builder.alias;
        this.arguments = builder.arguments;
        this.objectType = builder.objectType;
        this.fieldDefinition = Assert.assertNotNull(builder.fieldDefinition);
        this.children = builder.children;
        this.level = builder.level;
        this.parent = builder.parent;
        this.isConditional = this.parent == null ? false : (parentType = GraphQLTypeUtil.unwrapAll(this.parent.getFieldDefinition().getType())) != this.objectType;
    }

    public String getName() {
        return this.getFieldDefinition().getName();
    }

    public String getResultKey() {
        if (this.alias != null) {
            return this.alias;
        }
        return this.getName();
    }

    public String getAlias() {
        return this.alias;
    }

    public boolean isConditional() {
        return this.isConditional;
    }

    public Map<String, Object> getArguments() {
        return this.arguments;
    }

    public static Builder newQueryExecutionField() {
        return new Builder();
    }

    public GraphQLFieldDefinition getFieldDefinition() {
        return this.fieldDefinition;
    }

    public NormalizedField transform(Consumer<Builder> builderConsumer) {
        Builder builder = new Builder(this);
        builderConsumer.accept(builder);
        return builder.build();
    }

    public GraphQLObjectType getObjectType() {
        return this.objectType;
    }

    public String printDetails() {
        StringBuilder result = new StringBuilder();
        if (this.getAlias() != null) {
            result.append(this.getAlias()).append(": ");
        }
        return result + this.objectType.getName() + "." + this.fieldDefinition.getName() + ": " + GraphQLTypeUtil.simplePrint(this.fieldDefinition.getType()) + " (conditional: " + this.isConditional + ")";
    }

    public String print() {
        StringBuilder result = new StringBuilder();
        result.append("(");
        if (this.getAlias() != null) {
            result.append(this.getAlias()).append(":");
        }
        return result + this.objectType.getName() + "." + this.fieldDefinition.getName() + ")";
    }

    public String printFullPath() {
        StringBuilder result = new StringBuilder();
        for (NormalizedField cur = this; cur != null; cur = cur.getParent()) {
            if (result.length() > 0) {
                result.insert(0, "/");
            }
            result.insert(0, cur.print());
        }
        return result.toString();
    }

    public List<String> getListOfResultKeys() {
        LinkedList<String> list = new LinkedList<String>();
        NormalizedField current = this;
        while (current != null) {
            list.addFirst(current.getResultKey());
            current = current.parent;
        }
        return list;
    }

    public List<NormalizedField> getChildren() {
        return this.children;
    }

    public int getLevel() {
        return this.level;
    }

    public NormalizedField getParent() {
        return this.parent;
    }

    public void replaceParent(NormalizedField newParent) {
        this.parent = newParent;
    }

    public boolean isIntrospectionField() {
        return this.getFieldDefinition().getName().startsWith("__") || this.getObjectType().getName().startsWith("__");
    }

    public String toString() {
        return "NormalizedField{" + this.objectType.getName() + "." + this.fieldDefinition.getName() + ", alias=" + this.alias + ", level=" + this.level + ", conditional=" + this.isConditional + ", children=" + this.children.stream().map(NormalizedField::toString).collect(Collectors.joining("\n")) + '}';
    }

    public List<NormalizedField> getChildren(int includingRelativeLevel) {
        ArrayList<NormalizedField> result = new ArrayList<NormalizedField>();
        Assert.assertTrue(includingRelativeLevel >= 1, () -> "relative level must be >= 1");
        this.getChildren().forEach(child -> this.traverseImpl((NormalizedField)child, result::add, 1, includingRelativeLevel));
        return result;
    }

    public void traverseSubTree(Consumer<NormalizedField> consumer) {
        this.getChildren().forEach(child -> this.traverseImpl((NormalizedField)child, consumer, 1, Integer.MAX_VALUE));
    }

    private void traverseImpl(NormalizedField root, Consumer<NormalizedField> consumer, int curRelativeLevel, int abortAfter) {
        if (curRelativeLevel > abortAfter) {
            return;
        }
        consumer.accept(root);
        root.getChildren().forEach(child -> this.traverseImpl((NormalizedField)child, consumer, curRelativeLevel + 1, abortAfter));
    }

    public static class Builder {
        private GraphQLObjectType objectType;
        private GraphQLFieldDefinition fieldDefinition;
        private List<NormalizedField> children = new ArrayList<NormalizedField>();
        private int level;
        private NormalizedField parent;
        private String alias;
        private Map<String, Object> arguments = Collections.emptyMap();

        private Builder() {
        }

        private Builder(NormalizedField existing) {
            this.alias = existing.alias;
            this.arguments = existing.arguments;
            this.objectType = existing.getObjectType();
            this.fieldDefinition = existing.getFieldDefinition();
            this.children = existing.getChildren();
            this.level = existing.getLevel();
            this.parent = existing.getParent();
        }

        public Builder objectType(GraphQLObjectType objectType) {
            this.objectType = objectType;
            return this;
        }

        public Builder alias(String alias) {
            this.alias = alias;
            return this;
        }

        public Builder arguments(Map<String, Object> arguments) {
            this.arguments = arguments == null ? Collections.emptyMap() : arguments;
            return this;
        }

        public Builder fieldDefinition(GraphQLFieldDefinition fieldDefinition) {
            this.fieldDefinition = fieldDefinition;
            return this;
        }

        public Builder children(List<NormalizedField> children) {
            this.children.clear();
            this.children.addAll(children);
            return this;
        }

        public Builder level(int level) {
            this.level = level;
            return this;
        }

        public Builder parent(NormalizedField parent) {
            this.parent = parent;
            return this;
        }

        public NormalizedField build() {
            return new NormalizedField(this);
        }
    }
}

