/*
 * Decompiled with CFR 0.152.
 */
package graphql.schema;

import graphql.Assert;
import graphql.Internal;
import graphql.com.google.common.collect.ImmutableList;
import graphql.normalized.NormalizedField;
import graphql.schema.DataFetchingFieldSelectionSet;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLTypeUtil;
import graphql.schema.GraphQLUnmodifiedType;
import graphql.schema.SelectedField;
import graphql.util.FpKit;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;

@Internal
public class DataFetchingFieldSelectionSetImpl
implements DataFetchingFieldSelectionSet {
    private static final String SEP = "/";
    private static final DataFetchingFieldSelectionSet NOOP = new DataFetchingFieldSelectionSet(){

        @Override
        public boolean contains(String fieldGlobPattern) {
            return false;
        }

        @Override
        public boolean containsAnyOf(String fieldGlobPattern, String ... fieldGlobPatterns) {
            return false;
        }

        @Override
        public boolean containsAllOf(String fieldGlobPattern, String ... fieldGlobPatterns) {
            return false;
        }

        @Override
        public List<SelectedField> getFields() {
            return Collections.emptyList();
        }

        @Override
        public List<SelectedField> getImmediateFields() {
            return Collections.emptyList();
        }

        @Override
        public List<SelectedField> getFields(String fieldGlobPattern, String ... fieldGlobPatterns) {
            return Collections.emptyList();
        }

        @Override
        public Map<String, List<SelectedField>> getFieldsGroupedByResultKey() {
            return Collections.emptyMap();
        }

        @Override
        public Map<String, List<SelectedField>> getFieldsGroupedByResultKey(String fieldGlobPattern, String ... fieldGlobPatterns) {
            return Collections.emptyMap();
        }
    };
    private final Supplier<NormalizedField> normalizedFieldSupplier;
    private boolean computedValues;
    private List<SelectedField> immediateFields;
    private Map<String, List<SelectedField>> normalisedSelectionSetFields;
    private Set<String> flattenedFieldsForGlobSearching;

    public static DataFetchingFieldSelectionSet newCollector(GraphQLOutputType fieldType, Supplier<NormalizedField> normalizedFieldSupplier) {
        if (!GraphQLTypeUtil.isLeaf(fieldType)) {
            return new DataFetchingFieldSelectionSetImpl(normalizedFieldSupplier);
        }
        return NOOP;
    }

    private DataFetchingFieldSelectionSetImpl(Supplier<NormalizedField> normalizedFieldSupplier) {
        this.normalizedFieldSupplier = normalizedFieldSupplier;
        this.computedValues = false;
    }

    @Override
    public boolean contains(String fieldGlobPattern) {
        if (fieldGlobPattern == null || fieldGlobPattern.isEmpty()) {
            return false;
        }
        this.computeValuesLazily();
        fieldGlobPattern = this.removeLeadingSlash(fieldGlobPattern);
        PathMatcher globMatcher = DataFetchingFieldSelectionSetImpl.globMatcher(fieldGlobPattern);
        for (String flattenedField : this.flattenedFieldsForGlobSearching) {
            Path path = Paths.get(flattenedField, new String[0]);
            if (!globMatcher.matches(path)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsAnyOf(String fieldGlobPattern, String ... fieldGlobPatterns) {
        Assert.assertNotNull(fieldGlobPattern);
        Assert.assertNotNull(fieldGlobPatterns);
        for (String globPattern : this.mkIterable(fieldGlobPattern, fieldGlobPatterns)) {
            if (!this.contains(globPattern)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsAllOf(String fieldGlobPattern, String ... fieldGlobPatterns) {
        Assert.assertNotNull(fieldGlobPattern);
        Assert.assertNotNull(fieldGlobPatterns);
        for (String globPattern : this.mkIterable(fieldGlobPattern, fieldGlobPatterns)) {
            if (this.contains(globPattern)) continue;
            return false;
        }
        return true;
    }

    @Override
    public List<SelectedField> getFields(String fieldGlobPattern, String ... fieldGlobPatterns) {
        if (fieldGlobPattern == null || fieldGlobPattern.isEmpty()) {
            return Collections.emptyList();
        }
        this.computeValuesLazily();
        ArrayList<String> targetNames = new ArrayList<String>();
        for (String flattenedField : this.flattenedFieldsForGlobSearching) {
            for (String globPattern : this.mkIterable(fieldGlobPattern, fieldGlobPatterns)) {
                Path path;
                PathMatcher globMatcher = DataFetchingFieldSelectionSetImpl.globMatcher(globPattern);
                if (!globMatcher.matches(path = Paths.get(flattenedField, new String[0]))) continue;
                targetNames.add(flattenedField);
            }
        }
        return targetNames.stream().flatMap(name -> this.normalisedSelectionSetFields.getOrDefault(name, Collections.emptyList()).stream()).collect(ImmutableList.toImmutableList());
    }

    @Override
    public List<SelectedField> getFields() {
        this.computeValuesLazily();
        return this.normalisedSelectionSetFields.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
    }

    @Override
    public List<SelectedField> getImmediateFields() {
        this.computeValuesLazily();
        return this.immediateFields;
    }

    @Override
    public Map<String, List<SelectedField>> getFieldsGroupedByResultKey() {
        return this.getFields().stream().collect(Collectors.groupingBy(SelectedField::getResultKey));
    }

    @Override
    public Map<String, List<SelectedField>> getFieldsGroupedByResultKey(String fieldGlobPattern, String ... fieldGlobPatterns) {
        return this.getFields(fieldGlobPattern, fieldGlobPatterns).stream().collect(Collectors.groupingBy(SelectedField::getResultKey));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void computeValuesLazily() {
        if (this.computedValues) {
            return;
        }
        DataFetchingFieldSelectionSetImpl dataFetchingFieldSelectionSetImpl = this;
        synchronized (dataFetchingFieldSelectionSetImpl) {
            if (this.computedValues) {
                return;
            }
            this.flattenedFieldsForGlobSearching = new LinkedHashSet<String>();
            this.normalisedSelectionSetFields = new LinkedHashMap<String, List<SelectedField>>();
            this.immediateFields = new ArrayList<SelectedField>();
            this.traverseSubSelectedFields(this.normalizedFieldSupplier.get(), "", "", true);
            this.computedValues = true;
        }
    }

    private void traverseSubSelectedFields(NormalizedField currentNormalisedField, String qualifiedFieldPrefix, String simpleFieldPrefix, boolean firstLevel) {
        List<NormalizedField> children = currentNormalisedField.getChildren();
        for (NormalizedField normalizedSubSelectedField : children) {
            String typeQualifiedName = DataFetchingFieldSelectionSetImpl.mkTypeQualifiedName(normalizedSubSelectedField);
            String simpleName = normalizedSubSelectedField.getName();
            String globQualifiedName = DataFetchingFieldSelectionSetImpl.mkFieldGlobName(qualifiedFieldPrefix, typeQualifiedName);
            String globSimpleName = DataFetchingFieldSelectionSetImpl.mkFieldGlobName(simpleFieldPrefix, simpleName);
            this.flattenedFieldsForGlobSearching.add(globQualifiedName);
            this.flattenedFieldsForGlobSearching.add(globSimpleName);
            SelectedFieldImpl selectedField = new SelectedFieldImpl(globSimpleName, globQualifiedName, normalizedSubSelectedField);
            if (firstLevel) {
                this.immediateFields.add(selectedField);
            }
            this.normalisedSelectionSetFields.computeIfAbsent(globQualifiedName, FpKit.newList()).add(selectedField);
            this.normalisedSelectionSetFields.computeIfAbsent(globSimpleName, FpKit.newList()).add(selectedField);
            GraphQLFieldDefinition fieldDefinition = normalizedSubSelectedField.getFieldDefinition();
            GraphQLUnmodifiedType unwrappedType = GraphQLTypeUtil.unwrapAll(fieldDefinition.getType());
            if (GraphQLTypeUtil.isLeaf(unwrappedType)) continue;
            this.traverseSubSelectedFields(normalizedSubSelectedField, globQualifiedName, globSimpleName, false);
        }
    }

    private String removeLeadingSlash(String fieldGlobPattern) {
        if (fieldGlobPattern.startsWith(SEP)) {
            fieldGlobPattern = fieldGlobPattern.substring(1);
        }
        return fieldGlobPattern;
    }

    private static String mkTypeQualifiedName(NormalizedField normalizedField) {
        return normalizedField.getObjectType().getName() + "." + normalizedField.getName();
    }

    private static String mkFieldGlobName(String fieldPrefix, String fieldName) {
        return (!fieldPrefix.isEmpty() ? fieldPrefix + SEP : "") + fieldName;
    }

    private static PathMatcher globMatcher(String fieldGlobPattern) {
        return FileSystems.getDefault().getPathMatcher("glob:" + fieldGlobPattern);
    }

    private List<String> mkIterable(String fieldGlobPattern, String[] fieldGlobPatterns) {
        ArrayList<String> l = new ArrayList<String>();
        l.add(fieldGlobPattern);
        Collections.addAll(l, fieldGlobPatterns);
        return l;
    }

    public String toString() {
        if (!this.computedValues) {
            return "notComputed";
        }
        return String.join((CharSequence)"\n", this.flattenedFieldsForGlobSearching);
    }

    private static class SelectedFieldImpl
    implements SelectedField {
        private final String qualifiedName;
        private final String fullyQualifiedName;
        private final DataFetchingFieldSelectionSet selectionSet;
        private final NormalizedField normalizedField;

        private SelectedFieldImpl(String simpleQualifiedName, String fullyQualifiedName, NormalizedField normalizedField) {
            this.qualifiedName = simpleQualifiedName;
            this.fullyQualifiedName = fullyQualifiedName;
            this.normalizedField = normalizedField;
            this.selectionSet = new DataFetchingFieldSelectionSetImpl(() -> normalizedField);
        }

        private SelectedField mkParent(NormalizedField normalizedField) {
            String parentSimpleQualifiedName = this.beforeLastSlash(this.qualifiedName);
            String parentFullyQualifiedName = this.beforeLastSlash(this.fullyQualifiedName);
            return normalizedField.getParent() == null ? null : new SelectedFieldImpl(parentSimpleQualifiedName, parentFullyQualifiedName, normalizedField.getParent());
        }

        private String beforeLastSlash(String name) {
            int index = name.lastIndexOf(DataFetchingFieldSelectionSetImpl.SEP);
            if (index > 0) {
                return name.substring(0, index);
            }
            return "";
        }

        @Override
        public String getName() {
            return this.normalizedField.getName();
        }

        @Override
        public String getQualifiedName() {
            return this.qualifiedName;
        }

        @Override
        public String getFullyQualifiedName() {
            return this.fullyQualifiedName;
        }

        @Override
        public GraphQLObjectType getObjectType() {
            return this.normalizedField.getObjectType();
        }

        @Override
        public GraphQLFieldDefinition getFieldDefinition() {
            return this.normalizedField.getFieldDefinition();
        }

        @Override
        public Map<String, Object> getArguments() {
            return this.normalizedField.getArguments();
        }

        @Override
        public int getLevel() {
            return this.normalizedField.getLevel();
        }

        @Override
        public boolean isConditional() {
            return this.normalizedField.isConditional();
        }

        @Override
        public String getAlias() {
            return this.normalizedField.getAlias();
        }

        @Override
        public String getResultKey() {
            return this.normalizedField.getResultKey();
        }

        @Override
        public SelectedField getParentField() {
            return this.mkParent(this.normalizedField);
        }

        @Override
        public DataFetchingFieldSelectionSet getSelectionSet() {
            return this.selectionSet;
        }

        public String toString() {
            return this.getQualifiedName();
        }
    }
}

