/*
 * Decompiled with CFR 0.152.
 */
package graphql.schema;

import graphql.Assert;
import graphql.PublicApi;
import graphql.schema.GraphQLNamedSchemaElement;
import graphql.schema.GraphQLSchemaElement;
import graphql.schema.GraphQLType;
import graphql.schema.GraphqlTypeComparatorEnvironment;
import graphql.schema.GraphqlTypeComparatorRegistry;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.function.UnaryOperator;

@PublicApi
public class DefaultGraphqlTypeComparatorRegistry
implements GraphqlTypeComparatorRegistry {
    public static final Comparator<GraphQLSchemaElement> DEFAULT_COMPARATOR = Comparator.comparing(graphQLSchemaElement -> ((GraphQLNamedSchemaElement)graphQLSchemaElement).getName());
    private Map<GraphqlTypeComparatorEnvironment, Comparator<?>> registry = new HashMap();

    private DefaultGraphqlTypeComparatorRegistry() {
    }

    private DefaultGraphqlTypeComparatorRegistry(Map<GraphqlTypeComparatorEnvironment, Comparator<?>> registry) {
        this.registry = registry;
    }

    @Override
    public <T extends GraphQLSchemaElement> Comparator<? super T> getComparator(GraphqlTypeComparatorEnvironment environment) {
        Comparator<?> comparator = this.registry.get(environment);
        if (comparator != null) {
            return comparator;
        }
        comparator = this.registry.get(environment.transform(builder -> builder.parentType(null)));
        if (comparator != null) {
            return comparator;
        }
        return DEFAULT_COMPARATOR;
    }

    public static GraphqlTypeComparatorRegistry defaultComparators() {
        return new DefaultGraphqlTypeComparatorRegistry();
    }

    public static Builder newComparators() {
        return new Builder();
    }

    public static class Builder {
        private Map<GraphqlTypeComparatorEnvironment, Comparator<?>> registry = new HashMap();

        public <T extends GraphQLType> Builder addComparator(GraphqlTypeComparatorEnvironment environment, Class<T> comparatorClass, Comparator<? super T> comparator) {
            Assert.assertNotNull(environment, () -> "environment can't be null");
            Assert.assertNotNull(comparatorClass, () -> "comparatorClass can't be null");
            Assert.assertNotNull(comparator, () -> "comparator can't be null");
            this.registry.put(environment, comparator);
            return this;
        }

        public <T extends GraphQLType> Builder addComparator(UnaryOperator<GraphqlTypeComparatorEnvironment.Builder> builderFunction, Class<T> comparatorClass, Comparator<? super T> comparator) {
            Assert.assertNotNull(builderFunction, () -> "builderFunction can't be null");
            GraphqlTypeComparatorEnvironment environment = ((GraphqlTypeComparatorEnvironment.Builder)builderFunction.apply(GraphqlTypeComparatorEnvironment.newEnvironment())).build();
            return this.addComparator(environment, comparatorClass, comparator);
        }

        public DefaultGraphqlTypeComparatorRegistry build() {
            return new DefaultGraphqlTypeComparatorRegistry(this.registry);
        }
    }
}

